/*
 * Decompiled with CFR 0.152.
 */
package marvin.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import marvin.color.MarvinColorModelConverter;

public class MarvinImage
implements Cloneable {
    public static final int COLOR_MODEL_RGB = 0;
    public static final int COLOR_MODEL_BINARY = 1;
    public static final int PROPORTIONAL = 0;
    protected BufferedImage image;
    protected int[] arrIntColor;
    protected boolean[] arrBinaryColor;
    protected int rgb;
    protected int r;
    protected int b;
    protected int g;
    protected Color color;
    protected int colorModel;
    protected String formatName;
    protected int numComponents;
    int width;
    int height;

    public MarvinImage() {
        this(1, 1);
    }

    public MarvinImage(BufferedImage img) {
        this.image = img;
        this.formatName = "jpg";
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.colorModel = 0;
        this.updateColorArray();
        this.image = new BufferedImage(this.width, this.height, 2);
    }

    public MarvinImage(BufferedImage img, String fmtName) {
        this.image = img;
        this.formatName = fmtName;
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.colorModel = 0;
        this.updateColorArray();
        this.image = new BufferedImage(this.width, this.height, 2);
    }

    public MarvinImage(int w, int h) {
        this.colorModel = 0;
        this.formatName = "jpg";
        this.setDimension(w, h);
    }

    public MarvinImage(int w, int h, int cm) {
        this.colorModel = cm;
        this.formatName = "jpg";
        this.setDimension(w, h);
    }

    public int getComponents() {
        return this.numComponents;
    }

    public MarvinImage subimage(int x, int y, int width, int height) {
        MarvinImage ret = new MarvinImage(width, height);
        ret.setColorModel(this.getColorModel());
        for (int i = y; i < y + height; ++i) {
            block5: for (int j = x; j < x + width; ++j) {
                switch (this.colorModel) {
                    case 0: {
                        ret.setIntColor(j - x, i - y, this.getIntColor(j, i));
                        continue block5;
                    }
                    case 1: {
                        ret.setBinaryColor(j - x, i - y, this.getBinaryColor(j, i));
                    }
                }
            }
        }
        return ret;
    }

    public void updateColorArray() {
        this.arrIntColor = this.image.getRGB(0, 0, this.image.getWidth(), this.image.getHeight(), null, 0, this.image.getWidth());
    }

    public void update() {
        int w = this.image.getWidth();
        switch (this.colorModel) {
            case 0: {
                this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), this.arrIntColor, 0, w);
                break;
            }
            case 1: {
                this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), MarvinColorModelConverter.binaryToRgb(this.arrBinaryColor), 0, w);
            }
        }
    }

    public void clear() {
        this.clear(0);
    }

    public void clear(int color) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.setIntColor(x, y, color);
            }
        }
    }

    public int getType() {
        return this.image.getType();
    }

    public int getColorModel() {
        return this.colorModel;
    }

    public void setColorModel(int cm) {
        this.colorModel = cm;
        this.allocColorArray();
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setDimension(int w, int h) {
        this.image = new BufferedImage(w, h, 2);
        this.width = w;
        this.height = h;
        this.allocColorArray();
    }

    public void allocColorArray() {
        switch (this.colorModel) {
            case 0: {
                this.arrBinaryColor = null;
                this.arrIntColor = new int[this.width * this.height];
                break;
            }
            case 1: {
                this.arrIntColor = null;
                this.arrBinaryColor = new boolean[this.width * this.height];
            }
        }
    }

    public int[] getIntColorArray() {
        return this.arrIntColor;
    }

    public void setIntColorArray(int[] arr) {
        this.arrIntColor = arr;
    }

    public static void copyColorArray(MarvinImage imgSource, MarvinImage imgDestine) {
        if (imgSource.getColorModel() != imgDestine.getColorModel()) {
            throw new RuntimeException("copyColorArray(): Incompatible Images Color Model");
        }
        switch (imgSource.getColorModel()) {
            case 0: {
                MarvinImage.copyIntColorArray(imgSource, imgDestine);
                break;
            }
            case 1: {
                MarvinImage.copyBinaryColorArray(imgSource, imgDestine);
            }
        }
    }

    protected static void copyIntColorArray(MarvinImage imgSource, MarvinImage imgDestine) {
        System.arraycopy(imgSource.getIntColorArray(), 0, imgDestine.getIntColorArray(), 0, imgSource.getWidth() * imgSource.getHeight());
    }

    protected static void copyBinaryColorArray(MarvinImage imgSource, MarvinImage imgDestine) {
        System.arraycopy(imgSource.getBinaryColorArray(), 0, imgDestine.getBinaryColorArray(), 0, imgSource.getWidth() * imgSource.getHeight());
    }

    public boolean[] getBinaryColorArray() {
        return this.arrBinaryColor;
    }

    public boolean getBinaryColor(int x, int y) {
        return this.arrBinaryColor[y * this.width + x];
    }

    public void setBinaryColor(int x, int y, boolean value) {
        this.arrBinaryColor[y * this.width + x] = value;
    }

    public int getIntColor(int x, int y) {
        return this.arrIntColor[y * this.width + x];
    }

    public void setAlphaComponent(int x, int y, int alpha) {
        int color = this.arrIntColor[y * this.width + x];
        this.arrIntColor[y * this.width + x] = color = (alpha << 24) + (color & 0xFFFFFF);
    }

    public int getAlphaComponent(int x, int y) {
        return (this.arrIntColor[y * this.width + x] & 0xFF000000) >>> 24;
    }

    public int getIntComponent0(int x, int y) {
        return (this.arrIntColor[y * this.width + x] & 0xFF0000) >>> 16;
    }

    public int getIntComponent1(int x, int y) {
        return (this.arrIntColor[y * this.width + x] & 0xFF00) >>> 8;
    }

    public int getIntComponent2(int x, int y) {
        return this.arrIntColor[y * this.width + x] & 0xFF;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public boolean isValidPosition(int x, int y) {
        return x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight();
    }

    public void setIntColor(int x, int y, int alpha, int color) {
        this.arrIntColor[y * this.image.getWidth() + x] = (alpha << 24) + color;
    }

    public void setIntColor(int x, int y, int color) {
        this.arrIntColor[y * this.image.getWidth() + x] = color;
    }

    public void setIntColor(int x, int y, int c0, int c1, int c2) {
        int alpha = (this.arrIntColor[y * this.width + x] & 0xFF000000) >>> 24;
        this.setIntColor(x, y, alpha, c0, c1, c2);
    }

    public void setIntColor(int x, int y, int alpha, int c0, int c1, int c2) {
        this.arrIntColor[y * this.image.getWidth() + x] = (alpha << 24) + (c0 << 16) + (c1 << 8) + c2;
    }

    public void setBufferedImage(BufferedImage img) {
        this.image = img;
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.updateColorArray();
    }

    public BufferedImage getBufferedImage() {
        return this.image;
    }

    public BufferedImage getBufferedImageNoAlpha() {
        switch (this.colorModel) {
            case 0: {
                int pixels = this.width * this.height;
                int[] pixelData = new int[pixels];
                for (int i = 0; i < pixels; ++i) {
                    pixelData[i] = this.arrIntColor[i] & 0xFFFFFF;
                }
                BufferedImage image = new BufferedImage(this.width, this.height, 1);
                image.setRGB(0, 0, this.width, this.height, pixelData, 0, this.width);
                return image;
            }
            case 1: {
                int pixels = this.width * this.height;
                int[] pixelData = new int[pixels];
                for (int i = 0; i < pixels; ++i) {
                    pixelData[i] = this.arrBinaryColor[i] ? 0 : 0xFFFFFF;
                }
                BufferedImage image = new BufferedImage(this.width, this.height, 1);
                image.setRGB(0, 0, this.width, this.height, pixelData, 0, this.width);
                return image;
            }
        }
        return null;
    }

    public int limit8bitsColor(int color) {
        if (color > 255) {
            color = 255;
            return color;
        }
        if (color < 0) {
            color = 0;
            return color;
        }
        return color;
    }

    public int[] Multi8p(int x, int y, int[][] masc) {
        int aR = this.getIntComponent0(x - 1, y - 1);
        int bR = this.getIntComponent0(x - 1, y);
        int cR = this.getIntComponent0(x - 1, y + 1);
        int aG = this.getIntComponent1(x - 1, y - 1);
        int bG = this.getIntComponent1(x - 1, y);
        int cG = this.getIntComponent1(x - 1, y + 1);
        int aB = this.getIntComponent2(x - 1, y - 1);
        int bB = this.getIntComponent2(x - 1, y);
        int cB = this.getIntComponent2(x - 1, y + 1);
        int dR = this.getIntComponent0(x, y - 1);
        int eR = this.getIntComponent0(x, y);
        int fR = this.getIntComponent0(x, y + 1);
        int dG = this.getIntComponent1(x, y - 1);
        int eG = this.getIntComponent1(x, y);
        int fG = this.getIntComponent1(x, y + 1);
        int dB = this.getIntComponent2(x, y - 1);
        int eB = this.getIntComponent2(x, y);
        int fB = this.getIntComponent2(x, y + 1);
        int gR = this.getIntComponent0(x + 1, y - 1);
        int hR = this.getIntComponent0(x + 1, y);
        int iR = this.getIntComponent0(x + 1, y + 1);
        int gG = this.getIntComponent1(x + 1, y - 1);
        int hG = this.getIntComponent1(x + 1, y);
        int iG = this.getIntComponent1(x + 1, y + 1);
        int gB = this.getIntComponent2(x + 1, y - 1);
        int hB = this.getIntComponent2(x + 1, y);
        int iB = this.getIntComponent2(x + 1, y + 1);
        int[] rgb = new int[]{aR * masc[0][0] + bR * masc[0][1] + cR * masc[0][2] + dR * masc[1][0] + eR * masc[1][1] + fR * masc[1][2] + gR * masc[2][0] + hR * masc[2][1] + iR * masc[2][2], aG * masc[0][0] + bG * masc[0][1] + cG * masc[0][2] + dG * masc[1][0] + eG * masc[1][1] + fG * masc[1][2] + gG * masc[2][0] + hG * masc[2][1] + iG * masc[2][2], aB * masc[0][0] + bB * masc[0][1] + cB * masc[0][2] + dB * masc[1][0] + eB * masc[1][1] + fB * masc[1][2] + gB * masc[2][0] + hB * masc[2][1] + iB * masc[2][2]};
        return rgb;
    }

    public BufferedImage getNewImageInstance() {
        BufferedImage buf = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
        buf.setData(this.image.getData());
        return buf;
    }

    public BufferedImage getBufferedImage(int width, int height) {
        BufferedImage buf = new BufferedImage(width, height, 2);
        Graphics2D g2d = (Graphics2D)buf.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(this.image, 0, 0, width, height, null);
        g2d.dispose();
        return buf;
    }

    public BufferedImage getBufferedImage(int width, int height, int type) {
        int fWidth = 0;
        int fHeight = 0;
        double imgWidth = this.image.getWidth();
        double imgHeight = this.image.getHeight();
        switch (type) {
            case 0: {
                int wDif = (int)imgWidth - width;
                int hDif = (int)imgHeight - height;
                double factor = wDif > hDif ? (double)width / imgWidth : (double)height / imgHeight;
                fWidth = (int)Math.floor(imgWidth * factor);
                fHeight = (int)Math.floor(imgHeight * factor);
            }
        }
        return this.getBufferedImage(fWidth, fHeight);
    }

    public void resize(int w, int h) {
        BufferedImage buf = new BufferedImage(w, h, this.image.getType());
        Graphics2D g2d = (Graphics2D)buf.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(this.image, 0, 0, w, h, null);
        g2d.dispose();
        this.image = buf;
        this.width = w;
        this.height = h;
        this.updateColorArray();
    }

    public MarvinImage clone() {
        MarvinImage newMarvinImg = new MarvinImage(this.getWidth(), this.getHeight(), this.getColorModel());
        BufferedImage newImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        newMarvinImg.setBufferedImage(newImage);
        MarvinImage.copyColorArray(this, newMarvinImg);
        newMarvinImg.update();
        return newMarvinImg;
    }

    public double multi8p(int x, int y, double masc) {
        int aR = this.getIntComponent0(x - 1, y - 1);
        int bR = this.getIntComponent0(x - 1, y);
        int cR = this.getIntComponent0(x - 1, y + 1);
        int aG = this.getIntComponent1(x - 1, y - 1);
        int bG = this.getIntComponent1(x - 1, y);
        int cG = this.getIntComponent1(x - 1, y + 1);
        int aB = this.getIntComponent1(x - 1, y - 1);
        int bB = this.getIntComponent1(x - 1, y);
        int cB = this.getIntComponent1(x - 1, y + 1);
        int dR = this.getIntComponent0(x, y - 1);
        int eR = this.getIntComponent0(x, y);
        int fR = this.getIntComponent0(x, y + 1);
        int dG = this.getIntComponent1(x, y - 1);
        int eG = this.getIntComponent1(x, y);
        int fG = this.getIntComponent1(x, y + 1);
        int dB = this.getIntComponent1(x, y - 1);
        int eB = this.getIntComponent1(x, y);
        int fB = this.getIntComponent1(x, y + 1);
        int gR = this.getIntComponent0(x + 1, y - 1);
        int hR = this.getIntComponent0(x + 1, y);
        int iR = this.getIntComponent0(x + 1, y + 1);
        int gG = this.getIntComponent1(x + 1, y - 1);
        int hG = this.getIntComponent1(x + 1, y);
        int iG = this.getIntComponent1(x + 1, y + 1);
        int gB = this.getIntComponent1(x + 1, y - 1);
        int hB = this.getIntComponent1(x + 1, y);
        int iB = this.getIntComponent1(x + 1, y + 1);
        double rgb = 0.0;
        rgb = (double)aR * masc + (double)bR * masc + (double)cR * masc + (double)dR * masc + (double)eR * masc + (double)fR * masc + (double)gR * masc + (double)hR * masc + (double)iR * masc;
        return rgb;
    }

    public int boundRGB(int rgb) {
        if (rgb > 255) {
            rgb = 255;
            return rgb;
        }
        if (rgb < 0) {
            rgb = 0;
            return rgb;
        }
        return rgb;
    }

    public void drawLine(int x0, int y0, int x1, int y1, Color c) {
        int stepx;
        int stepy;
        int colorRGB = c.getRGB();
        int dy = y1 - y0;
        int dx = x1 - x0;
        if (dy < 0) {
            dy = -dy;
            stepy = -1;
        } else {
            stepy = 1;
        }
        if (dx < 0) {
            dx = -dx;
            stepx = -1;
        } else {
            stepx = 1;
        }
        this.setIntColor(x0, y0, colorRGB);
        if ((dx <<= 1) > (dy <<= 1)) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                fraction += dy;
                this.setIntColor(x0 += stepx, y0, colorRGB);
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                fraction += dx;
                this.setIntColor(x0, y0 += stepy, colorRGB);
            }
        }
    }

    public void drawRect(int x, int y, int w, int h, Color c) {
        int i;
        int color = c.getRGB();
        for (i = x; i < x + w; ++i) {
            this.setIntColor(i, y, color);
            this.setIntColor(i, y + (h - 1), color);
        }
        for (i = y; i < y + h; ++i) {
            this.setIntColor(x, i, color);
            this.setIntColor(x + (w - 1), i, color);
        }
    }

    public void drawRect(int x, int y, int w, int h, int length, Color c) {
        for (int i = 0; i < length; ++i) {
            this.drawRect(x + i, y + i, w - i * 2, h - i * 2, Color.green);
        }
    }

    public void fillRectBinaryt(int x, int y, int w, int h, boolean value) {
        if (this.colorModel == 1) {
            for (int i = x; i < x + w; ++i) {
                for (int j = y; j < y + h; ++j) {
                    if (i >= this.width || j >= this.height) continue;
                    this.setBinaryColor(i, j, value);
                }
            }
        }
    }

    public void fillRect(int x, int y, int w, int h, Color c) {
        int color = c.getRGB();
        for (int i = x; i < x + w; ++i) {
            for (int j = y; j < y + h; ++j) {
                if (i >= this.width || j >= this.height) continue;
                this.setIntColor(i, j, color);
            }
        }
    }

    public void setColorToAlpha(int alpha, int color) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if ((this.getIntColor(x, y) & 0xFFFFFF) != (color & 0xFFFFFF)) continue;
                this.setAlphaComponent(x, y, alpha);
            }
        }
    }

    public void setAlphaToColor(int color) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                if (this.getAlphaComponent(x, y) != 0) continue;
                this.setIntColor(x, y, -1);
            }
        }
    }

    public boolean equals(Object obj) {
        MarvinImage img = (MarvinImage)obj;
        int[] l_arrColor = img.getIntColorArray();
        if (this.getWidth() != img.getWidth() || this.getHeight() != img.getHeight()) {
            return false;
        }
        for (int l_cont = 0; l_cont < this.getHeight(); ++l_cont) {
            if (this.arrIntColor[l_cont] == l_arrColor[l_cont]) continue;
            return false;
        }
        return true;
    }
}

