/*
 * Decompiled with CFR 0.152.
 */
package marvin.image;

public class MarvinImageMask {
    public static MarvinImageMask NULL_MASK = new MarvinImageMask();
    private boolean[][] arrMask;
    private int width;
    private int height;

    public MarvinImageMask() {
        this.arrMask = null;
    }

    public MarvinImageMask(int w, int h) {
        this.width = w;
        this.height = h;
        this.arrMask = new boolean[this.width][this.height];
    }

    public MarvinImageMask(boolean[][] mask) {
        this.arrMask = mask;
        this.width = this.arrMask[0].length;
        this.height = this.arrMask.length;
    }

    public MarvinImageMask(int maskWidth, int maskHeight, int startX, int startY, int regionWidth, int regionHeight) {
        this(maskWidth, maskHeight);
        this.addRectRegion(startX, startY, regionWidth, regionHeight);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void addPixel(int x, int y) {
        this.arrMask[x][y] = true;
    }

    public void removePixel(int x, int y) {
        this.arrMask[x][y] = false;
    }

    public void clear() {
        if (this.arrMask != null) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.arrMask[x][y] = false;
                }
            }
        }
    }

    public boolean[][] getMask() {
        return this.arrMask;
    }

    public void addRectRegion(int startX, int startY, int regionWidth, int regionHeight) {
        for (int x = startX; x < startX + regionWidth; ++x) {
            for (int y = startY; y < startY + regionHeight; ++y) {
                this.arrMask[x][y] = true;
            }
        }
    }
}

