/*
 * Decompiled with CFR 0.152.
 */
package marvin.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.stream.ImageInputStream;
import marvin.image.MarvinImage;
import marvin.util.MarvinErrorHandler;

public class MarvinImageIO {
    public static MarvinImage loadImage(String a_filePath) {
        MarvinImage l_marvinImage = null;
        BufferedImage l_bufferedImage = null;
        ImageInputStream l_imageInputStream = null;
        File l_file = new File(a_filePath);
        if (!l_file.exists()) {
            throw MarvinErrorHandler.handle(MarvinErrorHandler.TYPE.ERROR_FILE_NOT_FOUND, a_filePath);
        }
        Iterator<ImageReader> l_ittReaders = ImageIO.getImageReadersByFormatName(a_filePath.substring(a_filePath.lastIndexOf(".") + 1));
        ImageReader l_reader = l_ittReaders.next();
        l_reader.addIIOReadWarningListener(new IIOReadWarningListener(){

            @Override
            public void warningOccurred(ImageReader source, String warning) {
                MarvinErrorHandler.handleDialog(MarvinErrorHandler.TYPE.BAD_FILE, warning);
            }
        });
        try {
            l_imageInputStream = ImageIO.createImageInputStream(l_file);
            l_reader.setInput(l_imageInputStream);
            l_bufferedImage = l_reader.read(0);
        }
        catch (Exception e) {
            throw MarvinErrorHandler.handle(MarvinErrorHandler.TYPE.ERROR_FILE_OPEN, a_filePath, e);
        }
        finally {
            if (l_imageInputStream != null) {
                try {
                    l_imageInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        String l_format = "";
        try {
            l_format = l_reader.getFormatName();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        l_marvinImage = new MarvinImage(l_bufferedImage, l_format);
        return l_marvinImage;
    }

    public static void saveImage(MarvinImage marvinImage, String filePath) {
        marvinImage.update();
        File l_file = new File(filePath);
        try {
            if (filePath.toUpperCase().endsWith(".JPEG") || filePath.toUpperCase().endsWith(".JPG")) {
                ImageIO.write((RenderedImage)marvinImage.getBufferedImageNoAlpha(), "JPEG", l_file);
            } else {
                ImageIO.write((RenderedImage)marvinImage.getBufferedImage(), filePath.substring(filePath.lastIndexOf(46) + 1), l_file);
            }
        }
        catch (Exception e) {
            throw MarvinErrorHandler.handle(MarvinErrorHandler.TYPE.ERROR_FILE_SAVE, filePath, e);
        }
    }
}

