/*
 * Decompiled with CFR 0.152.
 */
package marvin.performance;

import java.util.LinkedList;
import marvin.performance.MarvinPerformanceEvent;

public class MarvinPerformanceEntry {
    String id;
    String name;
    private LinkedList<MarvinPerformanceEvent> listEvents;
    private MarvinPerformanceEvent currentEvent;

    public MarvinPerformanceEntry(String a_id, String a_name) {
        this.name = a_name;
        this.id = a_id;
        this.listEvents = new LinkedList();
    }

    public MarvinPerformanceEvent getEvent(int a_index) {
        return this.listEvents.get(a_index);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int size() {
        return this.listEvents.size();
    }

    public void startEvent(String a_id, String a_name) {
        this.currentEvent = new MarvinPerformanceEvent(a_id, a_name);
        this.currentEvent.start();
        this.listEvents.add(this.currentEvent);
    }

    public void finishEvent() {
        if (this.currentEvent != null) {
            this.currentEvent.finish();
        }
    }

    public void stepFinished() {
        if (this.currentEvent != null) {
            this.currentEvent.stepFinished();
        }
    }

    public void stepsFinished(int a_steps) {
        if (this.currentEvent != null) {
            this.currentEvent.stepsFinished(a_steps);
        }
    }

    public long getCurrentStep() {
        long l_currentStep = 0L;
        Object[] l_events = this.listEvents.toArray();
        for (int i = 0; i < l_events.length; ++i) {
            l_currentStep += (long)((MarvinPerformanceEvent)l_events[i]).getCurrentStep();
        }
        return l_currentStep;
    }

    public long getTotalTime() {
        long l_totalTime = 0L;
        Object[] l_events = this.listEvents.toArray();
        for (int i = 0; i < l_events.length; ++i) {
            l_totalTime += ((MarvinPerformanceEvent)l_events[i]).getTotalTime();
        }
        return l_totalTime;
    }
}

