/*
 * Decompiled with CFR 0.152.
 */
package marvin.performance;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import marvin.performance.MarvinPerformanceEntry;
import marvin.performance.MarvinPerformanceEvent;
import marvin.performance.MarvinPerformanceRegistry;
import marvin.statistic.MarvinBarChart;
import marvin.statistic.MarvinBarChartEntry;

public class MarvinPerformanceWindow
extends JFrame {
    private JPanel mainPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel tempPanel;
    private GridLayout leftPanelLayout;
    private GridLayout rightPanelLayout;
    MarvinBarChart tempTimeBarChart;
    MarvinBarChart tempStepsBarChart;

    public MarvinPerformanceWindow(MarvinPerformanceRegistry a_registry) {
        super("Performance statistics");
        this.setSize(800, 580);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.rightPanel = new JPanel();
        this.rightPanelLayout = new GridLayout(2, 1);
        this.rightPanelLayout.setVgap(30);
        this.rightPanel.setLayout(this.rightPanelLayout);
        this.tempPanel = new JPanel();
        this.tempPanel.setLayout(new FlowLayout());
        this.tempPanel.add(this.rightPanel);
        this.mainPanel.add((Component)this.tempPanel, "East");
        this.leftPanel = new JPanel();
        this.leftPanelLayout = new GridLayout(0, 1);
        this.leftPanelLayout.setVgap(30);
        this.leftPanel.setLayout(this.leftPanelLayout);
        this.tempPanel = new JPanel();
        this.tempPanel.setLayout(new FlowLayout());
        this.tempPanel.add(this.leftPanel);
        this.mainPanel.add((Component)this.tempPanel, "West");
        this.getContentPane().add(this.mainPanel);
        this.tempTimeBarChart = new MarvinBarChart("Process time (milliseconds):");
        this.tempTimeBarChart.setBarsColor(1);
        this.tempStepsBarChart = new MarvinBarChart("Procedures:");
        this.tempStepsBarChart.setBarsColor(1);
        for (int i = 0; i < a_registry.size(); ++i) {
            MarvinPerformanceEntry l_entry = a_registry.getEntry(i);
            this.leftPanelLayout.setRows(this.leftPanelLayout.getRows() + 1);
            this.tempPanel = new JPanel();
            this.tempPanel.setLayout(new GridLayout(3, 1));
            this.tempPanel.add(new JLabel(" Plugin name: " + l_entry.getName()));
            this.tempPanel.add(new JLabel(" Duration: " + l_entry.getTotalTime() + " ms."));
            this.tempPanel.add(new JLabel(" Procedures: " + l_entry.getCurrentStep()));
            this.leftPanel.add(this.tempPanel);
            for (int w = 0; w < l_entry.size(); ++w) {
                MarvinPerformanceEvent l_event = l_entry.getEvent(w);
                this.leftPanelLayout.setRows(this.leftPanelLayout.getRows() + 1);
                this.tempTimeBarChart.addEntry(new MarvinBarChartEntry(l_event.getName(), l_event.getTotalTime(), Color.blue));
                this.tempStepsBarChart.addEntry(new MarvinBarChartEntry(l_event.getName(), l_event.getCurrentStep(), Color.blue));
                this.tempPanel = new JPanel();
                this.tempPanel.setLayout(new GridLayout(3, 1));
                this.tempPanel.add(new JLabel(" Step name: " + l_event.getName()));
                this.tempPanel.add(new JLabel(" Duration: " + l_event.getTotalTime() + " ms."));
                this.tempPanel.add(new JLabel(" Procedures: " + l_event.getCurrentStep()));
                this.leftPanel.add(this.tempPanel);
            }
        }
        this.rightPanel.add(new JLabel(new ImageIcon(this.tempTimeBarChart.getImage(500, 250))));
        this.rightPanel.add(new JLabel(new ImageIcon(this.tempStepsBarChart.getImage(500, 250))));
        this.setVisible(true);
    }
}

