/*
 * Decompiled with CFR 0.152.
 */
package marvin.util;

import java.util.LinkedHashMap;
import marvin.plugin.MarvinPlugin;

public class MarvinAttributes {
    private MarvinPlugin plugin;
    protected LinkedHashMap<String, Object> hashAttributes;

    public MarvinAttributes(MarvinPlugin p) {
        this.plugin = p;
        this.hashAttributes = new LinkedHashMap();
    }

    public MarvinAttributes() {
        this(null);
    }

    public void set(String name, Object value) {
        this.hashAttributes.put(name, value);
        if (this.plugin != null) {
            this.plugin.invalidate();
        }
    }

    public void set(Object ... params) {
        for (int i = 0; i < params.length; i += 2) {
            this.hashAttributes.put((String)params[i], params[i + 1]);
        }
        if (this.plugin != null) {
            this.plugin.invalidate();
        }
    }

    public Object get(String name) {
        return this.hashAttributes.get(name);
    }

    public Object get(String name, Object defaultValue) {
        Object o = this.get(name);
        if (o != null) {
            return o;
        }
        return defaultValue;
    }

    public String[] toStringArray() {
        String[] attrs = new String[this.hashAttributes.size() * 2];
        String[] keys = this.hashAttributes.keySet().toArray(new String[0]);
        for (int x = 0; x < keys.length; ++x) {
            attrs[x * 2] = keys[x];
            attrs[x * 2 + 1] = "" + this.hashAttributes.get(keys[x]);
        }
        return attrs;
    }

    public Object[] getValues() {
        Object[] o = this.hashAttributes.entrySet().toArray(new Object[0]);
        return o;
    }

    public MarvinAttributes clone() {
        MarvinAttributes attrs = new MarvinAttributes();
        attrs.plugin = this.plugin;
        String[] keys = this.hashAttributes.keySet().toArray(new String[0]);
        for (int x = 0; x < keys.length; ++x) {
            attrs.set(keys[x], this.hashAttributes.get(keys[x]));
        }
        return attrs;
    }
}

