/*
 * Decompiled with CFR 0.152.
 */
package marvin.util;

import java.security.InvalidParameterException;
import javax.swing.JOptionPane;

public class MarvinErrorHandler {
    public static RuntimeException handle(TYPE type, String complement) {
        return new RuntimeException(MarvinErrorHandler.getErrorMessage(type) + complement);
    }

    public static RuntimeException handle(TYPE type, String complement, Exception e) {
        return new RuntimeException(MarvinErrorHandler.getErrorMessage(type) + complement, e);
    }

    public static RuntimeException handle(TYPE type, Exception e) {
        return new RuntimeException(MarvinErrorHandler.getErrorMessage(type), e);
    }

    public static void handleDialog(TYPE type) {
        MarvinErrorHandler.handleDialog(MarvinErrorHandler.getErrorMessage(type));
    }

    public static void handleDialog(TYPE type, Exception err) {
        MarvinErrorHandler.handleDialog(MarvinErrorHandler.getErrorMessage(type), err);
    }

    public static void handleDialog(TYPE type, String args) {
        MarvinErrorHandler.handleDialog(MarvinErrorHandler.getErrorMessage(type), args);
    }

    private static String getErrorMessage(TYPE type) {
        switch (type) {
            case BAD_FILE: {
                return "Bad file format!";
            }
            case ERROR_FILE_OPEN: {
                return "Error while opening the file:";
            }
            case ERROR_FILE_SAVE: {
                return "Error while saving the image!";
            }
            case ERROR_FILE_CHOOSE: {
                return "Error while choosing the file!";
            }
            case ERROR_FILE_NOT_FOUND: {
                return "Error! File not found:";
            }
            case NO_IMAGE_LOADED: {
                return "No image loaded!";
            }
            case IMAGE_RELOAD: {
                return "Error while reloading the image!";
            }
            case ERROR_PLUGIN_NOT_FOUND: {
                return "Error: plug-in not found!";
            }
        }
        throw new InvalidParameterException("Unknown error type");
    }

    public static void handleDialog(String msg, Exception err) {
        JOptionPane.showMessageDialog(null, msg, "Marvin - Error", 0);
        if (err != null) {
            err.printStackTrace();
        }
    }

    public static void handleDialog(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Marvin - Error", 0);
    }

    public static void handleDialog(String msg, String err) {
        JOptionPane.showMessageDialog(null, msg + " " + err, "Marvin - Error", 0);
    }

    public static enum TYPE {
        BAD_FILE,
        ERROR_FILE_OPEN,
        ERROR_FILE_SAVE,
        ERROR_FILE_CHOOSE,
        ERROR_FILE_NOT_FOUND,
        NO_IMAGE_LOADED,
        IMAGE_RELOAD,
        ERROR_PLUGIN_NOT_FOUND;

    }
}

