/*
 * Decompiled with CFR 0.152.
 */
package marvin.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class MarvinJarLoader
extends ClassLoader {
    private JarFile jarFile;
    private Enumeration<JarEntry> eJarEntries;

    MarvinJarLoader(String jarPath) {
        super(MarvinJarLoader.class.getClassLoader());
        try {
            this.jarFile = new JarFile(jarPath);
        }
        catch (IOException a_expt) {
            a_expt.printStackTrace();
        }
    }

    public Object getObject(String className) {
        Class<?> l_class = this.getClass(className);
        try {
            Constructor<?> l_con = l_class.getConstructor(new Class[0]);
            return l_con.newInstance(new Object[0]);
        }
        catch (Exception a_expt) {
            a_expt.printStackTrace();
            return null;
        }
    }

    public Class<?> getClass(String name) {
        name = name.replace(".class", "");
        this.eJarEntries = this.jarFile.entries();
        JarEntry l_entry = null;
        byte[] l_arrBuffer = null;
        while (this.eJarEntries.hasMoreElements()) {
            l_entry = this.eJarEntries.nextElement();
            if (!l_entry.getName().contains(name + ".class")) continue;
            l_arrBuffer = this.getEntryBytes(l_entry);
            Class<?> l_class = super.defineClass(null, l_arrBuffer, 0, (int)l_entry.getSize());
            return l_class;
        }
        return null;
    }

    public byte[] getEntryBytes(JarEntry entry) {
        int l_size = (int)entry.getSize();
        byte[] l_arrBuffer = new byte[l_size];
        try {
            InputStream l_inputStream = this.jarFile.getInputStream(entry);
            for (int i = 0; i < l_size; ++i) {
                l_arrBuffer[i] = (byte)l_inputStream.read();
            }
        }
        catch (IOException a_expt) {
            a_expt.printStackTrace();
        }
        return l_arrBuffer;
    }

    @Override
    public Class<?> findClass(String name) {
        return this.getClass(name.substring(name.lastIndexOf(46) + 1));
    }
}

