/*
 * Decompiled with CFR 0.152.
 */
package marvin.video;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import marvin.image.MarvinImage;
import marvin.util.ConverterUtil;
import marvin.video.MarvinVideoInterface;
import marvin.video.MarvinVideoInterfaceException;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.OpenCVFrameGrabber;

public class MarvinJavaCVAdapter
implements MarvinVideoInterface {
    private FrameGrabber grabber;
    private opencv_core.IplImage image;
    private int width;
    private int height;
    private boolean connected;
    private int[] intArray;
    private MarvinImage marvinImage;
    private MODE mode;
    int frame = 1;

    @Override
    public void connect(int deviceIndex) throws MarvinVideoInterfaceException {
        this.connect(deviceIndex, 640, 480);
    }

    @Override
    public void connect(int deviceIndex, int width, int height) throws MarvinVideoInterfaceException {
        this.mode = MODE.DEVICE;
        this.width = width;
        this.height = height;
        this.marvinImage = new MarvinImage(width, height);
        this.intArray = new int[height * width * 4];
        try {
            this.grabber = FrameGrabber.createDefault((int)deviceIndex);
            this.grabber.setImageWidth(width);
            this.grabber.setImageHeight(height);
            this.grabber.start();
            this.grabber.grab();
            this.connected = true;
        }
        catch (Exception e) {
            throw new MarvinVideoInterfaceException("Error while trying to connect to the device", e);
        }
    }

    @Override
    public void loadResource(String path) throws MarvinVideoInterfaceException {
        this.mode = MODE.FILE;
        try {
            this.grabber = OpenCVFrameGrabber.createDefault((File)new File(path));
            this.grabber.start();
            BufferedImage bufImage = ConverterUtil.frametoBufferedImage(this.grabber.grabFrame());
            this.width = bufImage.getWidth();
            this.height = bufImage.getHeight();
            this.marvinImage = new MarvinImage(this.width, this.height);
            this.intArray = new int[this.height * this.width * 4];
            this.connected = true;
        }
        catch (Exception e) {
            throw new MarvinVideoInterfaceException("Error while trying to load resource", e);
        }
    }

    @Override
    public void disconnect() throws MarvinVideoInterfaceException {
        try {
            this.grabber.stop();
            this.connected = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getImageWidth() {
        return this.width;
    }

    @Override
    public int getImageHeight() {
        return this.height;
    }

    @Override
    public MarvinImage getFrame() throws MarvinVideoInterfaceException {
        if (this.connected) {
            this.image = null;
            try {
                if (this.mode == MODE.DEVICE || this.grabber.getFrameNumber() < this.grabber.getLengthInFrames() - 1) {
                    this.image = ConverterUtil.frametoIplImage(this.grabber.grab());
                    this.convertToIntArray(this.image, this.intArray);
                    this.marvinImage.setIntColorArray(this.intArray);
                    return this.marvinImage;
                }
            }
            catch (Exception e) {
                throw new MarvinVideoInterfaceException("Error while trying to grab a new frame", e);
            }
        }
        return null;
    }

    private void convertToIntArray(opencv_core.IplImage img, int[] arr) {
        ByteBuffer buffer = img.getByteBuffer();
        int ii = 0;
        for (int bi = 0; bi < buffer.limit() - 3; bi += 3) {
            arr[ii] = -16777216 + (buffer.get(bi + 2) << 16) + (buffer.get(bi + 1) << 8) + buffer.get(bi);
            ++ii;
        }
    }

    @Override
    public int getFrameNumber() {
        if (this.connected) {
            return this.grabber.getFrameNumber();
        }
        return -1;
    }

    @Override
    public void setFrameNumber(int number) throws MarvinVideoInterfaceException {
        if (this.connected) {
            try {
                this.grabber.setFrameNumber(number);
            }
            catch (Exception e) {
                throw new MarvinVideoInterfaceException("Error while setting frame number", e);
            }
        }
    }

    private static enum MODE {
        DEVICE,
        FILE;

    }
}

