/*
 * Decompiled with CFR 0.152.
 */
package marvinplugins;

import java.awt.Color;
import java.util.List;
import marvin.image.MarvinBlobSegment;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.image.MarvinSegment;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.artistic.mosaic.Mosaic;
import org.marvinproject.image.artistic.television.Television;
import org.marvinproject.image.background.determineSceneBackground.DetermineSceneBackground;
import org.marvinproject.image.blur.gaussianBlur.GaussianBlur;
import org.marvinproject.image.blur.pixelize.Pixelize;
import org.marvinproject.image.color.alphaBoundary.AlphaBoundary;
import org.marvinproject.image.color.blackAndWhite.BlackAndWhite;
import org.marvinproject.image.color.brightnessAndContrast.BrightnessAndContrast;
import org.marvinproject.image.color.colorChannel.ColorChannel;
import org.marvinproject.image.color.emboss.Emboss;
import org.marvinproject.image.color.grayScale.GrayScale;
import org.marvinproject.image.color.invert.Invert;
import org.marvinproject.image.color.sepia.Sepia;
import org.marvinproject.image.color.skinColorDetection.SkinColorDetection;
import org.marvinproject.image.color.thresholding.Thresholding;
import org.marvinproject.image.color.thresholdingNeighborhood.ThresholdingNeighborhood;
import org.marvinproject.image.combine.combineByMask.CombineByMask;
import org.marvinproject.image.combine.combineByTransparency.CombineByTransparency;
import org.marvinproject.image.combine.mergePhotos.MergePhotos;
import org.marvinproject.image.convolution.Convolution;
import org.marvinproject.image.corner.harris.Harris;
import org.marvinproject.image.corner.moravec.Moravec;
import org.marvinproject.image.corner.susan.Susan;
import org.marvinproject.image.edge.prewitt.Prewitt;
import org.marvinproject.image.edge.roberts.Roberts;
import org.marvinproject.image.edge.sobel.Sobel;
import org.marvinproject.image.equalization.histogramEqualization.HistogramEqualization;
import org.marvinproject.image.fill.boundaryFill.BoundaryFill;
import org.marvinproject.image.halftone.circles.Circles;
import org.marvinproject.image.halftone.dithering.Dithering;
import org.marvinproject.image.halftone.errorDiffusion.ErrorDiffusion;
import org.marvinproject.image.halftone.rylanders.Rylanders;
import org.marvinproject.image.morphological.boundary.Boundary;
import org.marvinproject.image.morphological.closing.Closing;
import org.marvinproject.image.morphological.dilation.Dilation;
import org.marvinproject.image.morphological.erosion.Erosion;
import org.marvinproject.image.morphological.opening.Opening;
import org.marvinproject.image.morphological.thinning.Thinning;
import org.marvinproject.image.pattern.findSubimage.FindSubimage;
import org.marvinproject.image.pattern.findTextRegions.FindTextRegions;
import org.marvinproject.image.quantization.grayScaleQuantization.GrayScaleQuantization;
import org.marvinproject.image.segmentation.crop.Crop;
import org.marvinproject.image.segmentation.floodfillSegmentation.FloodfillSegmentation;
import org.marvinproject.image.transform.flip.Flip;
import org.marvinproject.image.transform.scale.Scale;
import org.marvinproject.image.transform.watershed.Watershed;

public class MarvinPluginCollection {
    private static MarvinImagePlugin alphaBoundary;
    private static MarvinImagePlugin blackAndWhite;
    private static MarvinImagePlugin brightnessAndContrast;
    private static MarvinImagePlugin boundaryFill;
    private static MarvinImagePlugin colorChannel;
    private static MarvinImagePlugin combineByMask;
    private static MarvinImagePlugin combineByTransparency;
    private static MarvinImagePlugin convolution;
    private static MarvinImagePlugin crop;
    private static MarvinImagePlugin determineSceneBackground;
    private static MarvinImagePlugin emboss;
    private static MarvinImagePlugin findSubimage;
    private static MarvinImagePlugin findTextRegions;
    private static MarvinImagePlugin flip;
    private static MarvinImagePlugin floodfillSegmentation;
    private static MarvinImagePlugin gaussianBlur;
    private static MarvinImagePlugin grayScale;
    private static MarvinImagePlugin harris;
    private static MarvinImagePlugin histogramEqualization;
    private static MarvinImagePlugin halftoneCircles;
    private static MarvinImagePlugin halftoneDithering;
    private static MarvinImagePlugin halftoneErrorDiffusion;
    private static MarvinImagePlugin halftoneRylanders;
    private static MarvinImagePlugin imageSlicer;
    private static MarvinImagePlugin invertColors;
    private static MarvinImagePlugin iteratedFuncionSystems;
    private static MarvinImagePlugin juliaSet;
    private static MarvinImagePlugin lindenmayer;
    private static MarvinImagePlugin mandelbrot;
    private static MarvinImagePlugin mergePhotos;
    private static MarvinImagePlugin moravec;
    private static MarvinImagePlugin morphologicalBoundary;
    private static MarvinImagePlugin morphologicalClosing;
    private static MarvinImagePlugin morphologicalDilation;
    private static MarvinImagePlugin morphologicalErosion;
    private static MarvinImagePlugin morphologicalOpening;
    private static MarvinImagePlugin morphologicalThinning;
    private static MarvinImagePlugin mosaic;
    private static MarvinImagePlugin pixelize;
    private static MarvinImagePlugin prewitt;
    private static MarvinImagePlugin quantizationGrayScale;
    private static MarvinImagePlugin roberts;
    private static MarvinImagePlugin rotate;
    private static MarvinImagePlugin scale;
    private static MarvinImagePlugin sobel;
    private static MarvinImagePlugin skew;
    private static MarvinImagePlugin sepia;
    private static MarvinImagePlugin statisticalMaximum;
    private static MarvinImagePlugin statisticalMedian;
    private static MarvinImagePlugin statisticalMinimum;
    private static MarvinImagePlugin statisticalMode;
    private static MarvinImagePlugin subtract;
    private static MarvinImagePlugin susan;
    private static MarvinImagePlugin skinColorDetection;
    private static MarvinImagePlugin television;
    private static MarvinImagePlugin tileTexture;
    private static MarvinImagePlugin thresholding;
    private static MarvinImagePlugin thresholdingNeighborhood;
    private static MarvinImagePlugin watershed;
    private static boolean[][] boolean_3x3;

    public static void alphaBoundary(MarvinImage imageIn, int radius) {
        MarvinPluginCollection.alphaBoundary(imageIn.clone(), imageIn, radius);
    }

    public static void alphaBoundary(MarvinImage imageIn, MarvinImage imageOut, int radius) {
        alphaBoundary = MarvinPluginCollection.checkAndLoadImagePlugin(alphaBoundary, AlphaBoundary.class);
        alphaBoundary.setAttribute("radius", (Object)radius);
        alphaBoundary.process(imageIn, imageOut);
    }

    public static void blackAndWhite(MarvinImage image, int level) {
        MarvinPluginCollection.blackAndWhite(image, image, level);
    }

    public static void blackAndWhite(MarvinImage imageIn, MarvinImage imageOut, int level) {
        MarvinPluginCollection.blackAndWhite(imageIn, imageOut, level, MarvinImageMask.NULL_MASK);
    }

    public static void blackAndWhite(MarvinImage imageIn, MarvinImage imageOut, int level, MarvinImageMask mask) {
        blackAndWhite = MarvinPluginCollection.checkAndLoadImagePlugin(blackAndWhite, BlackAndWhite.class);
        blackAndWhite.setAttribute("level", (Object)level);
        blackAndWhite.process(imageIn, imageOut, mask);
    }

    public static void boundaryFill(MarvinImage imageIn, MarvinImage imageOut, int x, int y, Color color) {
        MarvinPluginCollection.boundaryFill(imageIn, imageOut, x, y, color, null, 0);
    }

    public static void boundaryFill(MarvinImage imageIn, MarvinImage imageOut, int x, int y, Color color, int threshold) {
        MarvinPluginCollection.boundaryFill(imageIn, imageOut, x, y, color, null, threshold);
    }

    public static void boundaryFill(MarvinImage imageIn, MarvinImage imageOut, int x, int y, Color color, MarvinImage tile, int threshold) {
        boundaryFill = MarvinPluginCollection.checkAndLoadImagePlugin(boundaryFill, BoundaryFill.class);
        boundaryFill.setAttribute("x", (Object)x);
        boundaryFill.setAttribute("y", (Object)y);
        boundaryFill.setAttribute("color", (Object)color);
        boundaryFill.setAttribute("tile", (Object)tile);
        boundaryFill.setAttribute("threshold", (Object)threshold);
        boundaryFill.process(imageIn, imageOut);
    }

    public static void brightnessAndContrast(MarvinImage image, int brightness, int contrast) {
        MarvinPluginCollection.brightnessAndContrast(image, image, brightness, contrast);
    }

    public static void brightnessAndContrast(MarvinImage imageIn, MarvinImage imageOut, int brightness, int contrast) {
        MarvinPluginCollection.brightnessAndContrast(imageIn, imageOut, brightness, contrast, MarvinImageMask.NULL_MASK);
    }

    public static void brightnessAndContrast(MarvinImage imageIn, MarvinImage imageOut, int brightness, int contrast, MarvinImageMask mask) {
        brightnessAndContrast = MarvinPluginCollection.checkAndLoadImagePlugin(brightnessAndContrast, BrightnessAndContrast.class);
        brightnessAndContrast.setAttribute("brightness", (Object)brightness);
        brightnessAndContrast.setAttribute("contrast", (Object)contrast);
        brightnessAndContrast.process(imageIn, imageOut, mask);
    }

    public static void combineByMask(MarvinImage imageA, MarvinImage imageB, MarvinImage imageOut, int x, int y, Color colorMask) {
        combineByMask = MarvinPluginCollection.checkAndLoadImagePlugin(combineByMask, CombineByMask.class);
        combineByMask.setAttribute("xi", (Object)x);
        combineByMask.setAttribute("yi", (Object)y);
        combineByMask.setAttribute("combinationImage", (Object)imageB);
        combineByMask.setAttribute("colorMask", (Object)colorMask);
        combineByMask.process(imageA, imageOut);
    }

    public static void combineByTransparency(MarvinImage imageA, MarvinImage imageB, MarvinImage imageOut, int x, int y, int transparency) {
        combineByTransparency = MarvinPluginCollection.checkAndLoadImagePlugin(combineByTransparency, CombineByTransparency.class);
        combineByTransparency.setAttribute("xi", (Object)x);
        combineByTransparency.setAttribute("yi", (Object)y);
        combineByTransparency.setAttribute("combinationImage", (Object)imageB);
        combineByTransparency.setAttribute("transparency", (Object)transparency);
        combineByTransparency.process(imageA, imageOut);
    }

    public static void convolution(MarvinImage imageIn, MarvinImage imageOut, double[][] matrix) {
        convolution = MarvinPluginCollection.checkAndLoadImagePlugin(convolution, Convolution.class);
        convolution.setAttribute("matrix", (Object)matrix);
        convolution.process(imageIn, imageOut);
    }

    public static void colorChannel(MarvinImage image, int red, int green, int blue) {
        MarvinPluginCollection.colorChannel(image, image, red, green, blue);
    }

    public static void colorChannel(MarvinImage imageIn, MarvinImage imageOut, int red, int green, int blue) {
        MarvinPluginCollection.colorChannel(imageIn, imageOut, red, green, blue, MarvinImageMask.NULL_MASK);
    }

    public static void colorChannel(MarvinImage imageIn, MarvinImage imageOut, int red, int green, int blue, MarvinImageMask mask) {
        colorChannel = MarvinPluginCollection.checkAndLoadImagePlugin(colorChannel, ColorChannel.class);
        colorChannel.setAttribute("red", (Object)red);
        colorChannel.setAttribute("green", (Object)green);
        colorChannel.setAttribute("blue", (Object)blue);
        colorChannel.process(imageIn, imageOut, mask);
    }

    public static void crop(MarvinImage imageIn, MarvinImage imageOut, int x, int y, int width, int height) {
        x = Math.min(Math.max(x, 0), imageIn.getWidth());
        y = Math.min(Math.max(y, 0), imageIn.getHeight());
        if (x + width > imageIn.getWidth()) {
            width = imageIn.getWidth() - x;
        }
        if (y + height > imageIn.getHeight()) {
            height = imageIn.getHeight() - y;
        }
        crop = MarvinPluginCollection.checkAndLoadImagePlugin(crop, Crop.class);
        crop.setAttribute("x", (Object)x);
        crop.setAttribute("y", (Object)y);
        crop.setAttribute("width", (Object)width);
        crop.setAttribute("height", (Object)height);
        crop.process(imageIn, imageOut);
    }

    public static void determineSceneBackground(List<MarvinImage> images, MarvinImage imageOut, int threshold) {
        determineSceneBackground = MarvinPluginCollection.checkAndLoadImagePlugin(determineSceneBackground, DetermineSceneBackground.class);
        determineSceneBackground.setAttribute("threshold", (Object)threshold);
        determineSceneBackground.process(images, imageOut);
    }

    public static List<MarvinSegment> findAllSubimages(MarvinImage subimage, MarvinImage original) {
        return MarvinPluginCollection.findAllSubimages(subimage, original, 1.0);
    }

    public static List<MarvinSegment> findAllSubimages(MarvinImage subimage, MarvinImage original, double similarity) {
        findSubimage = MarvinPluginCollection.checkAndLoadImagePlugin(flip, FindSubimage.class);
        findSubimage.setAttribute("subimage", (Object)subimage);
        findSubimage.setAttribute("similarity", (Object)similarity);
        MarvinAttributes output = new MarvinAttributes();
        findSubimage.process(original, null, output);
        return (List)output.get("matches");
    }

    public static MarvinSegment findSubimage(MarvinImage subimage, MarvinImage original, int startX, int startY) {
        return MarvinPluginCollection.findSubimage(subimage, original, startX, startY, 1.0);
    }

    public static MarvinSegment findSubimage(MarvinImage subimage, MarvinImage original, int startX, int startY, double similarity) {
        findSubimage = MarvinPluginCollection.checkAndLoadImagePlugin(flip, FindSubimage.class);
        findSubimage.setAttribute("subimage", (Object)subimage);
        findSubimage.setAttribute("similarity", (Object)similarity);
        findSubimage.setAttribute("findAll", (Object)false);
        findSubimage.setAttribute("startX", (Object)startX);
        findSubimage.setAttribute("startY", (Object)startY);
        MarvinAttributes output = new MarvinAttributes();
        findSubimage.process(original, null, output);
        List ret = (List)output.get("matches");
        if (ret.size() > 0) {
            return (MarvinSegment)ret.get(0);
        }
        return null;
    }

    public static List<MarvinSegment> findTextRegions(MarvinImage imageIn, int maxWhiteSpace, int maxFontLineWidth, int minTextWidth, int grayScaleThreshold) {
        findTextRegions = MarvinPluginCollection.checkAndLoadImagePlugin(findTextRegions, FindTextRegions.class);
        findTextRegions.setAttribute("maxWhiteSpace", (Object)maxWhiteSpace);
        findTextRegions.setAttribute("maxFontLineWidth", (Object)maxFontLineWidth);
        findTextRegions.setAttribute("minTextWidth", (Object)minTextWidth);
        findTextRegions.setAttribute("grayScaleThreshold", (Object)grayScaleThreshold);
        MarvinAttributes output = new MarvinAttributes();
        findTextRegions.process(imageIn, null, output);
        return (List)output.get("matches");
    }

    public static void emboss(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.emboss(imageIn, imageOut, MarvinImageMask.NULL_MASK);
    }

    public static void emboss(MarvinImage imageIn, MarvinImage imageOut, MarvinImageMask mask) {
        emboss = MarvinPluginCollection.checkAndLoadImagePlugin(emboss, Emboss.class);
        emboss.process(imageIn, imageOut, mask);
    }

    public static void flipHorizontally(MarvinImage imageIn, MarvinImage imageOut) {
        flip = MarvinPluginCollection.checkAndLoadImagePlugin(flip, Flip.class);
        flip.setAttribute("flip", (Object)"horizontal");
        flip.process(imageIn, imageOut);
    }

    public static void flipVertically(MarvinImage imageIn, MarvinImage imageOut) {
        flip = MarvinPluginCollection.checkAndLoadImagePlugin(flip, Flip.class);
        flip.setAttribute("flip", (Object)"vertical");
        flip.process(imageIn, imageOut);
    }

    public static MarvinSegment[] floodfillSegmentation(MarvinImage imageIn) {
        floodfillSegmentation = MarvinPluginCollection.checkAndLoadImagePlugin(floodfillSegmentation, FloodfillSegmentation.class);
        floodfillSegmentation.setAttribute("returnType", (Object)"MarvinSegment");
        MarvinAttributes output = new MarvinAttributes();
        floodfillSegmentation.process(imageIn, null, output);
        return (MarvinSegment[])output.get("segments");
    }

    public static MarvinBlobSegment[] floodfillSegmentationBlob(MarvinImage imageIn) {
        floodfillSegmentation = MarvinPluginCollection.checkAndLoadImagePlugin(floodfillSegmentation, FloodfillSegmentation.class);
        floodfillSegmentation.setAttribute("returnType", (Object)"MarvinBlobSegment");
        MarvinAttributes output = new MarvinAttributes();
        floodfillSegmentation.process(imageIn, null, output);
        return (MarvinBlobSegment[])output.get("blobSegments");
    }

    public static void gaussianBlur(MarvinImage imageIn, MarvinImage imageOut, int radius) {
        MarvinPluginCollection.gaussianBlur(imageIn, imageOut, radius, MarvinImageMask.NULL_MASK);
    }

    public static void gaussianBlur(MarvinImage imageIn, MarvinImage imageOut, int radius, MarvinImageMask mask) {
        gaussianBlur = MarvinPluginCollection.checkAndLoadImagePlugin(gaussianBlur, GaussianBlur.class);
        gaussianBlur.setAttribute("radius", (Object)radius);
        gaussianBlur.process(imageIn, imageOut, mask);
    }

    public static void grayScale(MarvinImage image) {
        MarvinPluginCollection.grayScale(image, image);
    }

    public static void grayScale(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.grayScale(imageIn, imageOut, MarvinImageMask.NULL_MASK);
    }

    public static void grayScale(MarvinImage imageIn, MarvinImage imageOut, MarvinImageMask mask) {
        grayScale = MarvinPluginCollection.checkAndLoadImagePlugin(grayScale, GrayScale.class);
        grayScale.process(imageIn, imageOut, mask);
    }

    public static void halftoneCircles(MarvinImage imageIn, MarvinImage imageOut, int circleWidth, int shift, int circlesDistance, MarvinImageMask mask) {
        halftoneCircles = MarvinPluginCollection.checkAndLoadImagePlugin(halftoneCircles, Circles.class);
        halftoneCircles.setAttribute("circleWidth", (Object)circleWidth);
        halftoneCircles.setAttribute("shift", (Object)shift);
        halftoneCircles.setAttribute("circlesDistance", (Object)circlesDistance);
        halftoneCircles.process(imageIn, imageOut, mask);
    }

    public static void halftoneCircles(MarvinImage imageIn, MarvinImage imageOut, int circleWidth, int shift, int circlesDistance) {
        MarvinPluginCollection.halftoneCircles(imageIn, imageOut, circleWidth, shift, circlesDistance, MarvinImageMask.NULL_MASK);
    }

    public static void halftoneDithering(MarvinImage imageIn, MarvinImage imageOut) {
        halftoneDithering = MarvinPluginCollection.checkAndLoadImagePlugin(halftoneDithering, Dithering.class);
        halftoneDithering.process(imageIn, imageOut);
    }

    public static void halftoneErrorDiffusion(MarvinImage imageIn, MarvinImage imageOut) {
        halftoneErrorDiffusion = MarvinPluginCollection.checkAndLoadImagePlugin(halftoneErrorDiffusion, ErrorDiffusion.class);
        halftoneErrorDiffusion.process(imageIn, imageOut);
    }

    public static void halftoneRaylanders(MarvinImage imageIn, MarvinImage imageOut) {
        halftoneRylanders = MarvinPluginCollection.checkAndLoadImagePlugin(halftoneRylanders, Rylanders.class);
        halftoneRylanders.process(imageIn, imageOut);
    }

    public static void harrisCorner(MarvinImage imageIn, int matrixSize, int threshold, double k) {
        harris = MarvinPluginCollection.checkAndLoadImagePlugin(harris, Harris.class);
        harris.setAttribute("matrixSize", (Object)matrixSize);
        harris.setAttribute("threshold", (Object)threshold);
        harris.setAttribute("k", (Object)k);
        harris.process(imageIn, imageIn);
    }

    public static void histogramEqualization(MarvinImage imageIn, MarvinImage imageOut) {
        histogramEqualization = MarvinPluginCollection.checkAndLoadImagePlugin(histogramEqualization, HistogramEqualization.class);
        histogramEqualization.process(imageIn, imageOut);
    }

    public static void invertColors(MarvinImage image) {
        MarvinPluginCollection.invertColors(image, image);
    }

    public static void invertColors(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.invertColors(imageIn, imageOut, MarvinImageMask.NULL_MASK);
    }

    public static void invertColors(MarvinImage imageIn, MarvinImage imageOut, MarvinImageMask mask) {
        invertColors = MarvinPluginCollection.checkAndLoadImagePlugin(invertColors, Invert.class);
        invertColors.process(imageIn, imageOut, mask);
    }

    public static void mergePhotos(List<MarvinImage> images, MarvinImage imageOut, int threshold) {
        mergePhotos = MarvinPluginCollection.checkAndLoadImagePlugin(mergePhotos, MergePhotos.class);
        mergePhotos.setAttribute("threshold", (Object)threshold);
        mergePhotos.process(images, imageOut);
    }

    public static int[][] moravec(MarvinImage imageIn, MarvinImage imageOut, int matrixSize, int threshold) {
        moravec = MarvinPluginCollection.checkAndLoadImagePlugin(moravec, Moravec.class);
        moravec.setAttribute("matrixSize", (Object)matrixSize);
        moravec.setAttribute("threshold", (Object)threshold);
        MarvinAttributes ret = new MarvinAttributes();
        moravec.process(imageIn, imageOut, ret);
        return (int[][])ret.get("cornernessMap");
    }

    public static void morphologicalBoundary(MarvinImage imageIn, MarvinImage imageOut) {
        morphologicalBoundary = MarvinPluginCollection.checkAndLoadImagePlugin(morphologicalBoundary, Boundary.class);
        morphologicalBoundary.setAttribute("matrix", (Object)boolean_3x3);
        morphologicalBoundary.process(imageIn, imageOut);
    }

    public static void morphologicalBoundary(MarvinImage imageIn, MarvinImage imageOut, boolean[][] matrix) {
        morphologicalBoundary = MarvinPluginCollection.checkAndLoadImagePlugin(morphologicalBoundary, Boundary.class);
        morphologicalBoundary.setAttribute("matrix", (Object)matrix);
        morphologicalBoundary.process(imageIn, imageOut);
    }

    public static void morphologicalClosing(MarvinImage imageIn, MarvinImage imageOut, boolean[][] matrix) {
        morphologicalClosing = MarvinPluginCollection.checkAndLoadImagePlugin(morphologicalClosing, Closing.class);
        morphologicalClosing.setAttribute("matrix", (Object)matrix);
        morphologicalClosing.process(imageIn, imageOut);
    }

    public static void morphologicalDilation(MarvinImage imageIn, MarvinImage imageOut, boolean[][] matrix) {
        morphologicalDilation = MarvinPluginCollection.checkAndLoadImagePlugin(morphologicalDilation, Dilation.class);
        morphologicalDilation.setAttribute("matrix", (Object)matrix);
        morphologicalDilation.process(imageIn, imageOut);
    }

    public static void morphologicalErosion(MarvinImage imageIn, MarvinImage imageOut, boolean[][] matrix) {
        morphologicalErosion = MarvinPluginCollection.checkAndLoadImagePlugin(morphologicalErosion, Erosion.class);
        morphologicalErosion.setAttribute("matrix", (Object)matrix);
        morphologicalErosion.process(imageIn, imageOut);
    }

    public static void morphologicalOpening(MarvinImage imageIn, MarvinImage imageOut, boolean[][] matrix) {
        morphologicalOpening = MarvinPluginCollection.checkAndLoadImagePlugin(morphologicalOpening, Opening.class);
        morphologicalOpening.setAttribute("matrix", (Object)matrix);
        morphologicalOpening.process(imageIn, imageOut);
    }

    public static void morphologicalThinning(MarvinImage imageIn, MarvinImage imageOut) {
        morphologicalThinning = MarvinPluginCollection.checkAndLoadImagePlugin(morphologicalThinning, Thinning.class);
        morphologicalThinning.process(imageIn, imageOut);
    }

    public static void mosaic(MarvinImage imageIn, MarvinImage imageOut, String shape, int width, boolean border) {
        mosaic = MarvinPluginCollection.checkAndLoadImagePlugin(mosaic, Mosaic.class);
        mosaic.setAttribute("shape", (Object)shape);
        mosaic.setAttribute("width", (Object)width);
        mosaic.setAttribute("border", (Object)border);
        mosaic.process(imageIn, imageOut);
    }

    public static void pixelize(MarvinImage imageIn, MarvinImage imageOut, int squareSide) {
        MarvinPluginCollection.pixelize(imageIn, imageOut, squareSide, MarvinImageMask.NULL_MASK);
    }

    public static void pixelize(MarvinImage imageIn, MarvinImage imageOut, int squareSide, MarvinImageMask mask) {
        pixelize = MarvinPluginCollection.checkAndLoadImagePlugin(pixelize, Pixelize.class);
        pixelize.setAttribute("squareSide", (Object)squareSide);
        pixelize.process(imageIn, imageOut, mask);
    }

    public static void prewitt(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.prewitt(imageIn, imageOut, 1.0, MarvinImageMask.NULL_MASK);
    }

    public static void prewitt(MarvinImage imageIn, MarvinImage imageOut, double intensity) {
        MarvinPluginCollection.prewitt(imageIn, imageOut, intensity, MarvinImageMask.NULL_MASK);
    }

    public static void prewitt(MarvinImage imageIn, MarvinImage imageOut, double intensity, MarvinImageMask mask) {
        prewitt = MarvinPluginCollection.checkAndLoadImagePlugin(prewitt, Prewitt.class);
        prewitt.setAttribute("intensity", (Object)intensity);
        prewitt.process(imageIn, imageOut, mask);
    }

    public static void quantizationGrayScale(MarvinImage imageIn, MarvinImage imageOut, int shades) {
        quantizationGrayScale = MarvinPluginCollection.checkAndLoadImagePlugin(quantizationGrayScale, GrayScaleQuantization.class);
        quantizationGrayScale.setAttributes(new Object[]{"shades", shades});
        quantizationGrayScale.process(imageIn, imageOut);
    }

    public static void roberts(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.roberts(imageIn, imageOut, MarvinImageMask.NULL_MASK);
    }

    public static void roberts(MarvinImage imageIn, MarvinImage imageOut, MarvinImageMask mask) {
        roberts = MarvinPluginCollection.checkAndLoadImagePlugin(roberts, Roberts.class);
        roberts.process(imageIn, imageOut, mask);
    }

    public static void scale(MarvinImage imageIn, MarvinImage imageOut, int width, int height) {
        scale = MarvinPluginCollection.checkAndLoadImagePlugin(roberts, Scale.class);
        scale.setAttribute("newWidth", (Object)width);
        scale.setAttribute("newHeight", (Object)height);
        scale.process(imageIn, imageOut);
    }

    public static void scale(MarvinImage imageIn, MarvinImage imageOut, int width) {
        int cWidth = imageIn.getWidth();
        int cHeight = imageIn.getHeight();
        double cFactor = (double)cHeight / (double)cWidth;
        int newHeight = (int)Math.ceil(cFactor * (double)width);
        MarvinPluginCollection.scale(imageIn, imageOut, width, newHeight);
    }

    public static void sepia(MarvinImage image, int intensity) {
        MarvinPluginCollection.sepia(image, image, intensity);
    }

    public static void sepia(MarvinImage imageIn, MarvinImage imageOut, int intensity) {
        MarvinPluginCollection.sepia(imageIn, imageOut, intensity, MarvinImageMask.NULL_MASK);
    }

    public static void sepia(MarvinImage imageIn, MarvinImage imageOut, int intensity, MarvinImageMask mask) {
        sepia = MarvinPluginCollection.checkAndLoadImagePlugin(sepia, Sepia.class);
        sepia.setAttribute("intensity", (Object)intensity);
        sepia.process(imageIn, imageOut, mask);
    }

    public static void sobel(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.sobel(imageIn, imageOut, MarvinImageMask.NULL_MASK);
    }

    public static void sobel(MarvinImage imageIn, MarvinImage imageOut, MarvinImageMask mask) {
        sobel = MarvinPluginCollection.checkAndLoadImagePlugin(sobel, Sobel.class);
        sobel.process(imageIn, imageOut, mask);
    }

    public static void skinColorDetection(MarvinImage image) {
        MarvinPluginCollection.skinColorDetection(image, image);
    }

    public static void skinColorDetection(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.skinColorDetection(imageIn, imageOut, MarvinImageMask.NULL_MASK);
    }

    public static void skinColorDetection(MarvinImage imageIn, MarvinImage imageOut, MarvinImageMask mask) {
        skinColorDetection = MarvinPluginCollection.checkAndLoadImagePlugin(skinColorDetection, SkinColorDetection.class);
        skinColorDetection.process(imageIn, imageOut, mask);
    }

    public static void susanCorner(MarvinImage imageIn, int matrixSize, int threshold) {
        susan = MarvinPluginCollection.checkAndLoadImagePlugin(susan, Susan.class);
        susan.setAttribute("matrixSize", (Object)matrixSize);
        susan.setAttribute("threshold", (Object)threshold);
        susan.process(imageIn, imageIn);
    }

    public static void television(MarvinImage image) {
        MarvinPluginCollection.television(image, image);
    }

    public static void television(MarvinImage imageIn, MarvinImage imageOut) {
        MarvinPluginCollection.television(imageIn, imageOut, MarvinImageMask.NULL_MASK);
    }

    public static void television(MarvinImage imageIn, MarvinImage imageOut, MarvinImageMask mask) {
        television = MarvinPluginCollection.checkAndLoadImagePlugin(television, Television.class);
        television.process(imageIn, imageOut, mask);
    }

    public static void thresholding(MarvinImage image, int threshold) {
        MarvinPluginCollection.thresholding(image, image, threshold);
    }

    public static void thresholding(MarvinImage image, int threshold, int thresholdRange) {
        MarvinPluginCollection.thresholding(image, image, threshold, thresholdRange);
    }

    public static void thresholding(MarvinImage imageIn, MarvinImage imageOut, int threshold) {
        MarvinPluginCollection.thresholding(imageIn, imageOut, threshold, -1);
    }

    public static void thresholding(MarvinImage imageIn, MarvinImage imageOut, int threshold, int thresholdRange) {
        MarvinPluginCollection.thresholding(imageIn, imageOut, threshold, thresholdRange, MarvinImageMask.NULL_MASK);
    }

    public static void thresholding(MarvinImage imageIn, MarvinImage imageOut, int threshold, int thresholdRange, MarvinImageMask mask) {
        thresholding = MarvinPluginCollection.checkAndLoadImagePlugin(thresholding, Thresholding.class);
        thresholding.setAttribute("threshold", (Object)threshold);
        thresholding.setAttribute("thresholdRange", (Object)thresholdRange);
        thresholding.process(imageIn, imageOut, mask);
    }

    public static void thresholdingNeighborhood(MarvinImage imageIn, MarvinImage imageOut, double thresholdPercentageOfAverage, int neighborhoodSide, int samplingPixelDistance) {
        thresholdingNeighborhood = MarvinPluginCollection.checkAndLoadImagePlugin(thresholding, ThresholdingNeighborhood.class);
        thresholdingNeighborhood.setAttribute("thresholdPercentageOfAverage", (Object)thresholdPercentageOfAverage);
        thresholdingNeighborhood.setAttribute("neighborhoodSide", (Object)neighborhoodSide);
        thresholdingNeighborhood.setAttribute("samplingPixelDistance", (Object)samplingPixelDistance);
        thresholdingNeighborhood.process(imageIn, imageOut);
    }

    public static void thumbnailByWidth(MarvinImage imageIn, MarvinImage imageOut, int newWidth) {
        MarvinPluginCollection.scale(imageIn, imageOut, newWidth);
    }

    public static void thumbnailByHeight(MarvinImage imageIn, MarvinImage imageOut, int newHeight) {
        double factor = (double)imageIn.getWidth() / (double)imageIn.getHeight();
        int newWidth = (int)((double)newHeight * factor);
        MarvinPluginCollection.scale(imageIn, imageOut, newWidth);
    }

    public static int[][] watershed(MarvinImage imageIn) {
        watershed = MarvinPluginCollection.checkAndLoadImagePlugin(watershed, Watershed.class);
        MarvinAttributes attr = new MarvinAttributes();
        thresholding.process(imageIn, imageIn, attr);
        return (int[][])attr.get("labels");
    }

    private static MarvinImagePlugin checkAndLoadImagePlugin(MarvinImagePlugin ref, Class<? extends MarvinImagePlugin> clazz) {
        if (ref != null) {
            return ref;
        }
        try {
            MarvinImagePlugin plugin = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            plugin.load();
            return plugin;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        boolean_3x3 = new boolean[][]{{true, true, true}, {true, true, true}, {true, true, true}};
    }
}

