/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.artistic.television;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Television
extends MarvinAbstractImagePlugin {
    public void load() {
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        boolean[][] l_arrMask = mask.getMask();
        for (int x = 0; x < imageIn.getWidth(); ++x) {
            for (int y = 0; y < imageIn.getHeight(); y += 3) {
                int w;
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                int r = 0;
                int g = 0;
                int b = 0;
                for (w = 0; w < 3; ++w) {
                    if (y + w >= imageIn.getHeight()) continue;
                    r += imageIn.getIntComponent0(x, y + w) / 2;
                    g += imageIn.getIntComponent1(x, y + w) / 2;
                    b += imageIn.getIntComponent2(x, y + w) / 2;
                }
                r = this.getValidInterval(r);
                g = this.getValidInterval(g);
                b = this.getValidInterval(b);
                for (w = 0; w < 3; ++w) {
                    if (y + w >= imageOut.getHeight()) continue;
                    if (w == 0) {
                        imageOut.setIntColor(x, y + w, imageIn.getAlphaComponent(x, y), r, 0, 0);
                        continue;
                    }
                    if (w == 1) {
                        imageOut.setIntColor(x, y + w, imageIn.getAlphaComponent(x, y), 0, g, 0);
                        continue;
                    }
                    if (w != 2) continue;
                    imageOut.setIntColor(x, y + w, imageIn.getAlphaComponent(x, y), 0, 0, b);
                }
            }
        }
    }

    public int getValidInterval(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }
}

