/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.blur.gaussianBlur;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class GaussianBlur
extends MarvinAbstractImagePlugin {
    private static final int RED = 0;
    private static final int GREEN = 1;
    private static final int BLUE = 2;
    MarvinAttributesPanel attributesPanel;
    MarvinAttributes attributes;
    MarvinPerformanceMeter performanceMeter;
    double[][] kernelMatrix;
    double[][][] resultMatrix;
    double[][] appiledkernelMatrix;
    int radius;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("radius", (Object)3);
        this.performanceMeter = new MarvinPerformanceMeter();
        this.radius = 3;
        this.kernelMatrix = this.getGaussianKernel();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblWidth", "Radius:");
            this.attributesPanel.addTextField("txtRadius", "radius", this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        int y;
        int x;
        this.radius = (Integer)this.attributes.get("radius");
        int l_imageWidth = imageIn.getWidth();
        int l_imageHeight = imageIn.getHeight();
        this.performanceMeter.start("Gaussian Blur");
        this.performanceMeter.enableProgressBar("Gaussian Blur", l_imageWidth * l_imageHeight + l_imageWidth);
        this.kernelMatrix = this.getGaussianKernel();
        this.resultMatrix = new double[l_imageWidth][l_imageHeight][3];
        this.appiledkernelMatrix = new double[l_imageWidth][l_imageHeight];
        boolean[][] l_arrMask = mask.getMask();
        this.performanceMeter.startEvent("Apply Kernel");
        for (x = 0; x < l_imageWidth; ++x) {
            for (y = 0; y < l_imageHeight; ++y) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                int l_pixelColor = imageIn.getIntColor(x, y);
                this.applyKernel(x, y, l_pixelColor, imageOut);
            }
            this.performanceMeter.incProgressBar(l_imageHeight);
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.startEvent("Apply result");
        for (x = 0; x < l_imageWidth; ++x) {
            for (y = 0; y < l_imageHeight; ++y) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                this.resultMatrix[x][y][0] = (short)(this.resultMatrix[x][y][0] / this.appiledkernelMatrix[x][y] % 256.0);
                this.resultMatrix[x][y][1] = (short)(this.resultMatrix[x][y][1] / this.appiledkernelMatrix[x][y] % 256.0);
                this.resultMatrix[x][y][2] = (short)(this.resultMatrix[x][y][2] / this.appiledkernelMatrix[x][y] % 256.0);
                imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), (int)this.resultMatrix[x][y][0], (int)this.resultMatrix[x][y][1], (int)this.resultMatrix[x][y][2]);
            }
            this.performanceMeter.incProgressBar();
            this.performanceMeter.stepsFinished(l_imageHeight);
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.finish();
    }

    private double[][] getGaussianKernel() {
        double[][] l_matrix = new double[this.radius * 2 + 1][this.radius * 2 + 1];
        double l_q = (double)this.radius / 3.0;
        this.performanceMeter.startEvent("Generate Gaussian Kernel");
        for (int x = 1; x <= this.radius * 2 + 1; ++x) {
            for (int y = 1; y <= this.radius * 2 + 1; ++y) {
                double l_x = Math.abs(x - (this.radius + 1));
                double l_y = Math.abs(y - (this.radius + 1));
                double l_distance = Math.sqrt(l_x * l_x + l_y * l_y);
                l_matrix[y - 1][x - 1] = 1.0 / (Math.PI * 2 * l_q * l_q) * Math.exp(-(l_distance * l_distance) / (2.0 * l_q * l_q));
            }
            this.performanceMeter.stepsFinished(this.radius * 2);
        }
        this.performanceMeter.finishEvent();
        return l_matrix;
    }

    private void applyKernel(int centerPixel_X, int centerPixel_Y, int pixelColor, MarvinImage image) {
        for (int y = centerPixel_Y; y < centerPixel_Y + this.radius * 2; ++y) {
            for (int x = centerPixel_X; x < centerPixel_X + this.radius * 2; ++x) {
                if (x - this.radius < 0 || x - this.radius >= image.getWidth() || y - this.radius < 0 || y - this.radius >= image.getHeight()) continue;
                double[] dArray = this.resultMatrix[x - this.radius][y - this.radius];
                dArray[0] = dArray[0] + (double)((pixelColor & 0xFF0000) >>> 16) * this.kernelMatrix[x - centerPixel_X][y - centerPixel_Y];
                double[] dArray2 = this.resultMatrix[x - this.radius][y - this.radius];
                dArray2[1] = dArray2[1] + (double)((pixelColor & 0xFF00) >>> 8) * this.kernelMatrix[x - centerPixel_X][y - centerPixel_Y];
                double[] dArray3 = this.resultMatrix[x - this.radius][y - this.radius];
                dArray3[2] = dArray3[2] + (double)(pixelColor & 0xFF) * this.kernelMatrix[x - centerPixel_X][y - centerPixel_Y];
                double[] dArray4 = this.appiledkernelMatrix[x - this.radius];
                int n = y - this.radius;
                dArray4[n] = dArray4[n] + this.kernelMatrix[x - centerPixel_X][y - centerPixel_Y];
            }
            this.performanceMeter.stepsFinished(this.radius * 2);
        }
    }
}

