/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.blur.pixelize;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Pixelize
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    MarvinAttributes attributes;
    private boolean[][] arrMask;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("squareSide", (Object)10);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblSquareSide", "Square Side");
            this.attributesPanel.addTextField("txtSquareSide", "squareSide", this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        int squareSide = (Integer)this.attributes.get("squareSide");
        this.arrMask = mask.getMask();
        for (int x = 0; x < imageIn.getWidth(); x += squareSide) {
            for (int y = 0; y < imageIn.getHeight(); y += squareSide) {
                int l_rgb = this.getPredominantRGB(imageIn, x, y, squareSide);
                this.fillRect(imageOut, x, y, squareSide, l_rgb);
            }
        }
    }

    private int getPredominantRGB(MarvinImage a_image, int a_x, int a_y, int a_squareSide) {
        int l_red = -1;
        int l_green = -1;
        int l_blue = -1;
        for (int x = a_x; x < a_x + a_squareSide; ++x) {
            for (int y = a_y; y < a_y + a_squareSide; ++y) {
                if (x >= a_image.getWidth() || y >= a_image.getHeight() || this.arrMask != null && !this.arrMask[x][y]) continue;
                l_red = l_red == -1 ? a_image.getIntComponent0(x, y) : (l_red + a_image.getIntComponent0(x, y)) / 2;
                l_green = l_green == -1 ? a_image.getIntComponent1(x, y) : (l_green + a_image.getIntComponent1(x, y)) / 2;
                l_blue = l_blue == -1 ? a_image.getIntComponent2(x, y) : (l_blue + a_image.getIntComponent2(x, y)) / 2;
            }
        }
        return -16777216 + (l_red << 16) + (l_green << 8) + l_blue;
    }

    private void fillRect(MarvinImage a_image, int a_x, int a_y, int a_squareSide, int a_rgb) {
        for (int x = a_x; x < a_x + a_squareSide; ++x) {
            for (int y = a_y; y < a_y + a_squareSide; ++y) {
                if (x >= a_image.getWidth() || y >= a_image.getHeight() || this.arrMask != null && !this.arrMask[x][y]) continue;
                a_image.setIntColor(x, y, a_rgb);
            }
        }
    }
}

