/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.brightnessAndContrast;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class BrightnessAndContrast
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("brightness", (Object)0);
        this.attributes.set("contrast", (Object)0);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblBrightness", "Brightness");
            this.attributesPanel.addHorizontalSlider("sliderBrightness", "brightness", -127, 127, 0, this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblContrast", "Contrast");
            this.attributesPanel.addHorizontalSlider("sliderContrast", "contrast", -127, 127, 0, this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        double b;
        double g;
        double r;
        int y;
        int x;
        double l_brightness = ((Integer)this.attributes.get("brightness")).intValue();
        double l_contrast = ((Integer)this.attributes.get("contrast")).intValue();
        l_contrast = Math.pow((127.0 + l_contrast) / 127.0, 2.0);
        for (x = 0; x < imageIn.getWidth(); ++x) {
            for (y = 0; y < imageIn.getHeight(); ++y) {
                r = imageIn.getIntComponent0(x, y);
                g = imageIn.getIntComponent1(x, y);
                b = imageIn.getIntComponent2(x, y);
                r += (1.0 - r / 255.0) * l_brightness;
                g += (1.0 - g / 255.0) * l_brightness;
                b += (1.0 - b / 255.0) * l_brightness;
                if (r < 0.0) {
                    r = 0.0;
                }
                if (r > 255.0) {
                    r = 255.0;
                }
                if (g < 0.0) {
                    g = 0.0;
                }
                if (g > 255.0) {
                    g = 255.0;
                }
                if (b < 0.0) {
                    b = 0.0;
                }
                if (b > 255.0) {
                    b = 255.0;
                }
                imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), (int)r, (int)g, (int)b);
            }
        }
        for (x = 0; x < imageIn.getWidth(); ++x) {
            for (y = 0; y < imageIn.getHeight(); ++y) {
                r = imageOut.getIntComponent0(x, y);
                g = imageOut.getIntComponent1(x, y);
                b = imageOut.getIntComponent2(x, y);
                r /= 255.0;
                r -= 0.5;
                r *= l_contrast;
                r += 0.5;
                r *= 255.0;
                g /= 255.0;
                g -= 0.5;
                g *= l_contrast;
                g += 0.5;
                g *= 255.0;
                b /= 255.0;
                b -= 0.5;
                b *= l_contrast;
                b += 0.5;
                b *= 255.0;
                if (r < 0.0) {
                    r = 0.0;
                }
                if (r > 255.0) {
                    r = 255.0;
                }
                if (g < 0.0) {
                    g = 0.0;
                }
                if (g > 255.0) {
                    g = 255.0;
                }
                if (b < 0.0) {
                    b = 0.0;
                }
                if (b > 255.0) {
                    b = 255.0;
                }
                imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), (int)r, (int)g, (int)b);
            }
        }
    }
}

