/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.color.thresholdingNeighborhood;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class ThresholdingNeighborhood
extends MarvinAbstractImagePlugin {
    public void load() {
        this.setAttribute("neighborhoodSide", 10);
        this.setAttribute("samplingPixelDistance", 1);
        this.setAttribute("thresholdPercentageOfAverage", 1.0);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attributesOut, MarvinImageMask mask, boolean previewMode) {
        int neighborhoodSide = (Integer)this.getAttribute("neighborhoodSide");
        int samplingPixelDistance = (Integer)this.getAttribute("samplingPixelDistance");
        double thresholdPercentageOfAverage = (Double)this.getAttribute("thresholdPercentageOfAverage");
        for (int y = 0; y < imageIn.getHeight(); ++y) {
            for (int x = 0; x < imageIn.getWidth(); ++x) {
                this.theshold(imageIn, imageOut, x, y, thresholdPercentageOfAverage, neighborhoodSide, samplingPixelDistance);
            }
        }
    }

    private void theshold(MarvinImage image, MarvinImage imageOut, int x, int y, double thresholdPercentageOfAverage, int side, int neighborhoodDistance) {
        int min = -1;
        int max = -1;
        int pixels = 0;
        int average = 0;
        int inc = neighborhoodDistance;
        for (int j = y - side / 2; j < y + (inc + side / 2); j += inc) {
            for (int i = x - side / 2; i < x + side / 2; i += inc) {
                if (i < 0 || j < 0 || i >= image.getWidth() || j >= image.getHeight()) continue;
                int color = image.getIntComponent0(i, j);
                if (min == -1 || color < min) {
                    min = color;
                }
                if (max == -1 || color > max) {
                    max = color;
                }
                average += color;
                ++pixels;
            }
        }
        int color = image.getIntComponent0(x, y);
        if ((double)color < (double)(average /= pixels) * thresholdPercentageOfAverage || max - min <= 30) {
            imageOut.setIntColor(x, y, 255, 0, 0, 0);
        } else {
            imageOut.setIntColor(x, y, 255, 255, 255, 255);
        }
    }
}

