/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.corner.harris;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class Harris
extends MarvinAbstractImagePlugin {
    private MarvinImagePlugin gray;

    public void load() {
        this.gray = new GrayScale();
        this.gray.load();
        this.setAttribute("matrixSize", 7);
        this.setAttribute("threshold", 500);
        this.setAttribute("k", 0.004);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        double k = (Double)this.getAttribute("k");
        int threshold = (Integer)this.getAttribute("threshold");
        int matrixSize = (Integer)this.getAttribute("matrixSize");
        MarvinImage tempImage = new MarvinImage(imageIn.getWidth(), imageIn.getHeight());
        this.gray.process(imageIn, tempImage);
        int width = tempImage.getWidth();
        int height = tempImage.getHeight();
        int[][] cornernessMapOut = new int[width][height];
        double[][] diffx = new double[width][height];
        double[][] diffy = new double[width][height];
        double[][] diffxy = new double[width][height];
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                float X = (float)(tempImage.getIntComponent0(x + 1, y - 1) + tempImage.getIntComponent0(x + 1, y) + tempImage.getIntComponent0(x + 1, y + 1) - (tempImage.getIntComponent0(x - 1, y - 1) + tempImage.getIntComponent0(x - 1, y) + tempImage.getIntComponent0(x - 1, y - 1))) * 0.16666667f;
                float Y = (float)(tempImage.getIntComponent0(x + 1, y + 1) + tempImage.getIntComponent0(x + 1, y) + tempImage.getIntComponent0(x, y + 1) - (tempImage.getIntComponent0(x - 1, y - 1) + tempImage.getIntComponent0(x - 1, y - 1) + tempImage.getIntComponent0(x - 1, y))) * 0.16666667f;
                diffx[x][y] = X * X;
                diffy[x][y] = Y * Y;
                diffxy[x][y] = X * Y;
            }
        }
        double[][] diffxGauss = new double[width][height];
        double[][] diffyGauss = new double[width][height];
        double[][] diffxyGauss = new double[width][height];
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                diffxGauss[x][y] = (diffx[x - 1][y - 1] + diffx[x][y - 1] * 2.0 + diffx[x + 1][y - 1] + diffx[x - 1][y] * 2.0 + diffx[x][y] * 4.0 + diffx[x + 1][y] * 2.0 + diffx[x - 1][y + 1] + diffx[x][y + 1] * 2.0 + diffx[x + 1][y + 1]) / 16.0;
                diffyGauss[x][y] = (diffy[x - 1][y - 1] + diffy[x][y - 1] * 2.0 + diffy[x + 1][y - 1] + diffy[x - 1][y] * 2.0 + diffy[x][y] * 4.0 + diffy[x + 1][y] * 2.0 + diffy[x - 1][y + 1] + diffy[x][y + 1] * 2.0 + diffy[x + 1][y + 1]) / 16.0;
                diffxyGauss[x][y] = (diffxy[x - 1][y - 1] + diffxy[x][y - 1] * 2.0 + diffxy[x + 1][y - 1] + diffxy[x - 1][y] * 2.0 + diffxy[x][y] * 4.0 + diffxy[x + 1][y] * 2.0 + diffxy[x - 1][y + 1] + diffxy[x][y + 1] * 2.0 + diffxy[x + 1][y + 1]) / 16.0;
            }
        }
        int[][] cornernessMap = new int[width][height];
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                double A = diffxGauss[x][y];
                double B = diffyGauss[x][y];
                double C = diffxyGauss[x][y];
                double M = A * B - C * C - k * (A + B) * (A + B);
                cornernessMap[x][y] = M > (double)threshold ? (int)M : 0;
            }
        }
        for (int x = 0; x < cornernessMap.length; ++x) {
            for (int y = 0; y < cornernessMap[x].length; ++y) {
                cornernessMapOut[x][y] = this.nonmax(x, y, matrixSize, cornernessMap);
                if (cornernessMapOut[x][y] <= 0) continue;
                cornernessMapOut[x][y] = 1;
            }
        }
        if (attrOut != null) {
            attrOut.set("cornernessMap", (Object)cornernessMapOut);
        }
    }

    private int nonmax(int x, int y, int matrixSize, int[][] matrix) {
        int s = matrixSize / 2;
        if (x - (s + 1) >= 0 && x + (s + 1) < matrix.length && y - (s + 1) >= 0 && y + (s + 1) < matrix[0].length) {
            for (int i = -s; i <= s; ++i) {
                for (int j = -s; j <= s; ++j) {
                    if (i == 0 && j == 0 || matrix[x][y] >= matrix[x + i][y + j]) continue;
                    return 0;
                }
            }
        }
        return matrix[x][y];
    }
}

