/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.difference.differenceColor;

import java.awt.Color;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class DifferenceColor
extends MarvinAbstractImagePlugin {
    private MarvinAttributes attributes;
    private MarvinImage imageB;
    private int colorRGB;
    private int colorRange;

    public void load() {
        this.setAttribute("colorRange", 30);
        this.setAttribute("differenceColor", Color.green);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage imgIn, MarvinImage imgOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        int colorRange = (Integer)this.getAttribute("colorRange");
        this.diff(imgIn, imgOut, colorRange, attrOut);
    }

    private void diff(MarvinImage imageA, MarvinImage imageB, int colorRange, MarvinAttributes attrOut) {
        int total = 0;
        for (int y = 0; y < imageA.getHeight(); ++y) {
            for (int x = 0; x < imageA.getWidth(); ++x) {
                int l_redA = imageA.getIntComponent0(x, y);
                int l_greenA = imageA.getIntComponent1(x, y);
                int l_blueA = imageA.getIntComponent2(x, y);
                int l_redB = imageB.getIntComponent0(x, y);
                int l_greenB = imageB.getIntComponent1(x, y);
                int l_blueB = imageB.getIntComponent2(x, y);
                if (Math.abs(l_redA - l_redB) > colorRange || Math.abs(l_greenA - l_greenB) > colorRange || Math.abs(l_blueA - l_blueB) > colorRange) {
                    if (imageB != null) {
                        imageB.setIntColor(x, y, this.colorRGB);
                    }
                    ++total;
                    continue;
                }
                if (imageB == null) continue;
                imageB.setIntColor(x, y, imageA.getIntColor(x, y));
            }
        }
        if (attrOut != null) {
            attrOut.set("total", (Object)total);
        }
    }
}

