/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.difference.differentRegions;

import java.util.Vector;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class DifferentRegions
extends MarvinAbstractImagePlugin {
    private MarvinAttributes attributes;
    private MarvinImage comparisonImage;
    private int[][] arrPixelsPerSubRegion;
    private boolean[][] arrRegionMask;
    private int width;
    private int height;
    private int colorRange;
    private int subRegionSide = 10;
    private boolean initialized = false;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("colorRange", (Object)30);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        this.comparisonImage = (MarvinImage)this.attributes.get("comparisonImage");
        this.colorRange = (Integer)this.attributes.get("colorRange");
        this.width = a_imageIn.getWidth();
        this.height = a_imageIn.getHeight();
        if (!this.initialized) {
            this.arrPixelsPerSubRegion = new int[this.width / this.subRegionSide][this.height / this.subRegionSide];
            this.arrRegionMask = new boolean[this.width / this.subRegionSide][this.height / this.subRegionSide];
            this.initialized = true;
        }
        this.clearRegions();
        for (int y = 0; y < a_imageIn.getHeight(); ++y) {
            for (int x = 0; x < a_imageIn.getWidth(); ++x) {
                int l_redA = a_imageIn.getIntComponent0(x, y);
                int l_greenA = a_imageIn.getIntComponent1(x, y);
                int l_blueA = a_imageIn.getIntComponent2(x, y);
                int l_redB = this.comparisonImage.getIntComponent0(x, y);
                int l_greenB = this.comparisonImage.getIntComponent1(x, y);
                int l_blueB = this.comparisonImage.getIntComponent2(x, y);
                if (Math.abs(l_redA - l_redB) <= this.colorRange && Math.abs(l_greenA - l_greenB) <= this.colorRange && Math.abs(l_blueA - l_blueB) <= this.colorRange) continue;
                int[] nArray = this.arrPixelsPerSubRegion[x / this.subRegionSide];
                int n = y / this.subRegionSide;
                nArray[n] = nArray[n] + 1;
            }
        }
        Vector<int[]> l_vecRegions = new Vector<int[]>();
        while (true) {
            int[] l_rect = new int[4];
            l_rect[0] = -1;
            this.JoinRegions(l_rect);
            if (l_rect[0] == -1) break;
            l_vecRegions.add(l_rect);
        }
        a_attributesOut.set("regions", l_vecRegions);
    }

    private boolean JoinRegions(int[] a_rect) {
        for (int x = 0; x < this.width / this.subRegionSide; ++x) {
            for (int y = 0; y < this.height / this.subRegionSide; ++y) {
                if (this.arrPixelsPerSubRegion[x][y] <= this.subRegionSide * this.subRegionSide / 2 || this.arrRegionMask[x][y]) continue;
                this.arrRegionMask[x][y] = true;
                a_rect[0] = x * this.subRegionSide;
                a_rect[1] = y * this.subRegionSide;
                a_rect[2] = x * this.subRegionSide;
                a_rect[3] = y * this.subRegionSide;
                this.testNeighbors(a_rect, x, y);
                return true;
            }
        }
        return false;
    }

    private void testNeighbors(int[] a_rect, int a_x, int a_y) {
        for (int x = a_x - 5; x < a_x + 5; ++x) {
            for (int y = a_y - 5; y < a_y + 5; ++y) {
                if (x <= 0 || x >= this.width / this.subRegionSide || y <= 0 || y >= this.height / this.subRegionSide || this.arrPixelsPerSubRegion[x][y] <= this.subRegionSide * this.subRegionSide / 2 || this.arrRegionMask[x][y]) continue;
                if (x * this.subRegionSide < a_rect[0]) {
                    a_rect[0] = x * this.subRegionSide;
                }
                if (x * this.subRegionSide > a_rect[2]) {
                    a_rect[2] = x * this.subRegionSide;
                }
                if (y * this.subRegionSide < a_rect[1]) {
                    a_rect[1] = y * this.subRegionSide;
                }
                if (y * this.subRegionSide > a_rect[3]) {
                    a_rect[3] = y * this.subRegionSide;
                }
                this.arrRegionMask[x][y] = true;
                this.testNeighbors(a_rect, x, y);
            }
        }
    }

    private void clearRegions() {
        for (int x = 0; x < this.width / this.subRegionSide; ++x) {
            for (int y = 0; y < this.height / this.subRegionSide; ++y) {
                this.arrPixelsPerSubRegion[x][y] = 0;
                this.arrRegionMask[x][y] = false;
            }
        }
    }
}

