/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.edge.edgeDetector;

import java.awt.Color;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class EdgeDetector
extends MarvinAbstractImagePlugin {
    private MarvinPerformanceMeter performanceMeter;
    private Color[] grayMatrix = new Color[256];

    public void load() {
        this.performanceMeter = new MarvinPerformanceMeter();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        int width = a_imageIn.getWidth();
        int height = a_imageIn.getHeight();
        boolean[][] mask = a_mask.getMask();
        this.performanceMeter.start("EdgeDetector");
        this.performanceMeter.enableProgressBar("EdgeDetector", (height - 2) * (width - 2));
        this.performanceMeter.startEvent("Sobel filter");
        for (int i = 0; i <= 255; ++i) {
            this.grayMatrix[i] = new Color(i, i, i);
        }
        int[][] luminance = new int[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (mask != null && !mask[x][y]) continue;
                luminance[x][y] = this.luminance(a_imageIn.getIntComponent0(x, y), a_imageIn.getIntComponent1(x, y), a_imageIn.getIntComponent2(x, y));
            }
        }
        for (int y = 1; y < height - 1; ++y) {
            for (int x = 1; x < width - 1; ++x) {
                if (mask != null && !mask[x][y]) continue;
                int grayX = -luminance[x - 1][y - 1] + luminance[x - 1][y - 1 + 2] - 2 * luminance[x - 1 + 1][y - 1] + 2 * luminance[x - 1 + 1][y - 1 + 2] - luminance[x - 1 + 2][y - 1] + luminance[x - 1 + 2][y - 1 + 2];
                int grayY = luminance[x - 1][y - 1] + 2 * luminance[x - 1][y - 1 + 1] + luminance[x - 1][y - 1 + 2] - luminance[x - 1 + 2][y - 1] - 2 * luminance[x - 1 + 2][y - 1 + 1] - luminance[x - 1 + 2][y - 1 + 2];
                grayX = 0;
                int magnitude = 255 - this.truncate(Math.abs(grayX) + Math.abs(grayY));
                Color grayscaleColor = this.grayMatrix[magnitude];
                a_imageOut.setIntColor(x, y, grayscaleColor.getRGB());
            }
            this.performanceMeter.incProgressBar(width);
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.finish();
    }

    private int truncate(int a) {
        if (a < 0) {
            return 0;
        }
        if (a > 255) {
            return 255;
        }
        return a;
    }

    private int luminance(int r, int g, int b) {
        return (int)(0.299 * (double)r + 0.58 * (double)g + 0.11 * (double)b);
    }
}

