/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.equalization.histogramEqualization;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class HistogramEqualization
extends MarvinAbstractImagePlugin {
    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean preview) {
        int blue;
        int green;
        int red;
        boolean[][] bmask = mask.getMask();
        int[] histRed = new int[256];
        int[] histGreen = new int[256];
        int[] histBlue = new int[256];
        for (int y = 0; y < imageIn.getHeight(); ++y) {
            for (int x = 0; x < imageIn.getWidth(); ++x) {
                if (bmask != null && !bmask[x][y]) continue;
                red = imageIn.getIntComponent0(x, y);
                green = imageIn.getIntComponent1(x, y);
                blue = imageIn.getIntComponent2(x, y);
                int n = red;
                histRed[n] = histRed[n] + 1;
                int n2 = green;
                histGreen[n2] = histGreen[n2] + 1;
                int n3 = blue;
                histBlue[n3] = histBlue[n3] + 1;
            }
        }
        int[] cdfRed = new int[256];
        int[] cdfGreen = new int[256];
        int[] cdfBlue = new int[256];
        cdfRed[0] = histRed[0];
        cdfGreen[0] = histGreen[0];
        cdfBlue[0] = histBlue[0];
        for (int i = 1; i < histRed.length; ++i) {
            cdfRed[i] = cdfRed[i - 1] + histRed[i];
            cdfGreen[i] = cdfGreen[i - 1] + histGreen[i];
            cdfBlue[i] = cdfBlue[i - 1] + histBlue[i];
        }
        int numberOfPixels = imageIn.getWidth() * imageIn.getHeight();
        int minRed = this.min(cdfRed);
        int minGreen = this.min(cdfGreen);
        int minBlue = this.min(cdfBlue);
        for (int x = 0; x < imageIn.getWidth(); ++x) {
            for (int y = 0; y < imageIn.getHeight(); ++y) {
                if (bmask != null && !bmask[x][y]) continue;
                red = imageIn.getIntComponent0(x, y);
                green = imageIn.getIntComponent1(x, y);
                blue = imageIn.getIntComponent2(x, y);
                red = (int)(((double)cdfRed[red] - (double)minRed) / (double)(numberOfPixels - minRed) * 255.0);
                green = (int)(((double)cdfGreen[green] - (double)minGreen) / (double)(numberOfPixels - minGreen) * 255.0);
                blue = (int)(((double)cdfBlue[blue] - (double)minBlue) / (double)(numberOfPixels - minBlue) * 255.0);
                imageOut.setIntColor(x, y, imageIn.getAlphaComponent(x, y), red, green, blue);
            }
        }
    }

    private int min(int[] arr) {
        int min = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (min != -1 && arr[i] >= min) continue;
            min = arr[i];
        }
        return min;
    }

    public void load() {
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }
}

