/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.fill.boundaryFill;

import java.awt.Color;
import java.awt.Point;
import java.util.LinkedList;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.texture.tileTexture.TileTexture;

public class BoundaryFill
extends MarvinAbstractImagePlugin {
    public void load() {
        this.setAttribute("x", 0);
        this.setAttribute("y", 0);
        this.setAttribute("color", Color.red);
        this.setAttribute("tile", null);
        this.setAttribute("threshold", 0);
    }

    public void process(MarvinImage imgIn, MarvinImage imgOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        LinkedList<Point> l_list = new LinkedList<Point>();
        int x = (Integer)this.getAttribute("x");
        int y = (Integer)this.getAttribute("y");
        MarvinImage tileImage = (MarvinImage)this.getAttribute("tile");
        int threshold = (Integer)this.getAttribute("threshold");
        if (!imgOut.isValidPosition(x, y)) {
            return;
        }
        int targetColor = imgIn.getIntColor(x, y);
        int targetRed = imgIn.getIntComponent0(x, y);
        int targetGreen = imgIn.getIntComponent1(x, y);
        int targetBlue = imgIn.getIntComponent2(x, y);
        Color color = (Color)this.getAttribute("color");
        int newColor = color.getRGB();
        boolean[][] fillMask = new boolean[imgOut.getWidth()][imgOut.getHeight()];
        fillMask[x][y] = true;
        l_list.add(new Point(x, y));
        while (l_list.size() > 0) {
            Point l_point = (Point)l_list.poll();
            Point l_pointW = new Point(l_point.x, l_point.y);
            Point l_pointE = new Point(l_point.x, l_point.y);
            while (l_pointW.x - 1 >= 0 && this.match(imgIn, l_pointW.x - 1, l_pointW.y, targetRed, targetGreen, targetBlue, threshold) && !fillMask[l_pointW.x - 1][l_pointW.y]) {
                --l_pointW.x;
            }
            while (l_pointE.x + 1 < imgIn.getWidth() && this.match(imgIn, l_pointE.x + 1, l_pointE.y, targetRed, targetGreen, targetBlue, threshold) && !fillMask[l_pointE.x + 1][l_pointE.y]) {
                ++l_pointE.x;
            }
            for (int l_px = l_pointW.x; l_px <= l_pointE.x; ++l_px) {
                fillMask[l_px][l_point.y] = true;
                if (l_point.y - 1 >= 0 && this.match(imgIn, l_px, l_point.y - 1, targetRed, targetGreen, targetBlue, threshold) && !fillMask[l_px][l_point.y - 1]) {
                    l_list.add(new Point(l_px, l_point.y - 1));
                }
                if (l_point.y + 1 >= imgOut.getHeight() || !this.match(imgIn, l_px, l_point.y + 1, targetRed, targetGreen, targetBlue, threshold) || fillMask[l_px][l_point.y + 1]) continue;
                l_list.add(new Point(l_px, l_point.y + 1));
            }
        }
        if (tileImage != null) {
            TileTexture p = new TileTexture();
            p.load();
            p.setAttribute("lines", (int)Math.ceil((double)imgOut.getHeight() / (double)tileImage.getHeight()));
            p.setAttribute("columns", (int)Math.ceil((double)imgOut.getWidth() / (double)tileImage.getWidth()));
            p.setAttribute("tile", tileImage);
            MarvinImageMask newMask = new MarvinImageMask(fillMask);
            p.process(imgOut, imgOut, null, newMask, false);
        } else {
            for (int j = 0; j < imgOut.getHeight(); ++j) {
                for (int i = 0; i < imgOut.getWidth(); ++i) {
                    if (!fillMask[i][j]) continue;
                    imgOut.setIntColor(i, j, newColor);
                }
            }
        }
    }

    private boolean match(MarvinImage image, int x, int y, int targetRed, int targetGreen, int targetBlue, int threshold) {
        int diff = Math.abs(image.getIntComponent0(x, y) - targetRed) + Math.abs(image.getIntComponent1(x, y) - targetGreen) + Math.abs(image.getIntComponent2(x, y) - targetBlue);
        return diff <= threshold;
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }
}

