/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.halftone.dithering;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class Dithering
extends MarvinAbstractImagePlugin {
    private static final int DOT_AREA = 5;
    private static final int[] arrDither = new int[]{167, 200, 230, 216, 181, 94, 72, 193, 242, 232, 36, 52, 222, 167, 200, 181, 126, 210, 94, 72, 232, 153, 111, 36, 52};

    public void load() {
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        GrayScale l_filter = new GrayScale();
        l_filter.load();
        l_filter.process(a_imageIn, a_imageIn, a_attributesOut, a_mask, a_previewMode);
        boolean[][] l_arrMask = a_mask.getMask();
        for (int x = 0; x < a_imageIn.getWidth(); x += 5) {
            for (int y = 0; y < a_imageIn.getHeight(); y += 5) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                this.drawTone(x, y, a_imageIn, a_imageOut);
            }
        }
    }

    private void drawTone(int a_x, int a_y, MarvinImage a_imageIn, MarvinImage a_imageOut) {
        for (int x = 0; x < 25; ++x) {
            int l_x = x % 5;
            int l_y = x / 5;
            if (a_x + l_x >= a_imageIn.getWidth() || a_y + l_y >= a_imageIn.getHeight()) continue;
            int l_grayIntensity = 255 - a_imageIn.getIntComponent0(a_x + l_x, a_y + l_y);
            if (l_grayIntensity > arrDither[x]) {
                a_imageOut.setIntColor(a_x + l_x, a_y + l_y, a_imageIn.getAlphaComponent(a_x + l_x, a_y + l_y), 0, 0, 0);
                continue;
            }
            a_imageOut.setIntColor(a_x + l_x, a_y + l_y, a_imageIn.getAlphaComponent(a_x + l_x, a_y + l_y), 255, 255, 255);
        }
    }
}

