/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.halftone.rylanders;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.color.grayScale.GrayScale;

public class Rylanders
extends MarvinAbstractImagePlugin {
    private static final int DOT_AREA = 4;
    private static final int[] arrPattern = new int[]{1, 9, 3, 11, 5, 13, 7, 15, 4, 12, 2, 10, 8, 16, 6, 14};

    public void load() {
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        GrayScale l_filter = new GrayScale();
        l_filter.load();
        l_filter.process(a_imageIn, a_imageIn, a_attributesOut, a_mask, a_previewMode);
        boolean[][] l_arrMask = a_mask.getMask();
        for (int x = 0; x < a_imageIn.getWidth(); x += 4) {
            for (int y = 0; y < a_imageIn.getHeight(); y += 4) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                double l_intensity = this.getSquareIntensity(x, y, a_imageIn);
                this.drawTone(x, y, a_imageIn, a_imageOut, l_intensity);
            }
        }
    }

    private void drawTone(int a_x, int a_y, MarvinImage a_imageIn, MarvinImage a_imageOut, double a_intensity) {
        double l_factor = 0.06666666666666667;
        int l_toneIntensity = (int)Math.floor(a_intensity / l_factor);
        for (int x = 0; x < 16; ++x) {
            int l_x = x % 4;
            int l_y = x / 4;
            if (a_x + l_x >= a_imageIn.getWidth() || a_y + l_y >= a_imageIn.getHeight()) continue;
            if (l_toneIntensity >= arrPattern[x]) {
                a_imageOut.setIntColor(a_x + l_x, a_y + l_y, 0, 0, 0);
                continue;
            }
            a_imageOut.setIntColor(a_x + l_x, a_y + l_y, 255, 255, 255);
        }
    }

    private double getSquareIntensity(int a_x, int a_y, MarvinImage image) {
        double l_totalValue = 0.0;
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                if (a_x + x >= image.getWidth() || a_y + y >= image.getHeight()) continue;
                l_totalValue += (double)(255 - image.getIntComponent0(a_x + x, a_y + y));
            }
        }
        return l_totalValue / 4080.0;
    }
}

