/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.morphological.thinning;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Thinning
extends MarvinAbstractImagePlugin {
    private static Boolean[][] B1 = new Boolean[][]{{false, false, false}, {null, true, null}, {true, true, true}};
    private static Boolean[][] B2 = new Boolean[][]{{null, false, false}, {true, true, false}, {true, true, null}};
    private static Boolean[][] B3 = new Boolean[][]{{true, null, false}, {true, true, false}, {true, null, false}};
    private static Boolean[][] B4 = new Boolean[][]{{true, true, null}, {true, true, false}, {null, false, false}};
    private static Boolean[][] B5 = new Boolean[][]{{true, true, true}, {null, true, null}, {false, false, false}};
    private static Boolean[][] B6 = new Boolean[][]{{null, true, true}, {false, true, true}, {false, false, null}};
    private static Boolean[][] B7 = new Boolean[][]{{false, null, true}, {false, true, true}, {false, null, true}};
    private static Boolean[][] B8 = new Boolean[][]{{false, false, null}, {false, true, true}, {null, true, true}};
    private Boolean[][][] MATRICES = new Boolean[][][]{B1, B2, B3, B4, B5, B6, B7, B8};

    public void load() {
    }

    public void process(MarvinImage imgIn, MarvinImage imgOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        if (imgIn.getColorModel() == 1) {
            MarvinImage tempImgIn = imgIn.clone();
            int lastChange = -1;
            boolean c = false;
            block0: while (true) {
                int mIndex = 0;
                while (true) {
                    if (mIndex >= this.MATRICES.length) continue block0;
                    boolean lastApplyChanged = false;
                    for (int y = 0; y < imgIn.getHeight(); ++y) {
                        for (int x = 0; x < imgIn.getWidth(); ++x) {
                            if (!this.apply(x, y, tempImgIn, imgOut, this.MATRICES[mIndex])) continue;
                            lastChange = mIndex;
                            lastApplyChanged = true;
                        }
                    }
                    if (lastApplyChanged) {
                        MarvinImage.copyColorArray((MarvinImage)imgOut, (MarvinImage)tempImgIn);
                    }
                    if (!lastApplyChanged && lastChange == mIndex) break block0;
                    ++mIndex;
                }
                break;
            }
        }
    }

    private boolean apply(int x, int y, MarvinImage imgIn, MarvinImage imgOut, Boolean[][] matrix) {
        int hi = matrix.length / 2;
        int hj = matrix[0].length / 2;
        int i = -hi;
        int mi = 0;
        while (i <= hi) {
            int j = -hj;
            int mj = 0;
            while (j <= hj) {
                int nx = x + i;
                int ny = y + j;
                if (nx < 0 || nx >= imgIn.getWidth() || ny < 0 || ny >= imgIn.getHeight() ? matrix[mj][mi] != null && matrix[mj][mi] != false : matrix[mj][mi] != null && imgIn.getBinaryColor(nx, ny) != matrix[mj][mi].booleanValue()) {
                    return false;
                }
                ++j;
                ++mj;
            }
            ++i;
            ++mi;
        }
        imgOut.setBinaryColor(x, y, false);
        return true;
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }
}

