/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.pattern.findColorPattern;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class FindColorPattern
extends MarvinAbstractImagePlugin {
    private int[] arrTargetPattern;
    private int[] arrTempPattern;
    private int patternWidth;
    private int patternHeight;
    private int regionPx;
    private int regionPy;
    private int regionWidth;
    private int regionHeight;
    private MarvinImage image;
    private int imageWidth;
    private int imageHeight;
    private int colorRange;
    private MarvinAttributes attributes;
    private boolean targetPatternLoaded = false;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("differenceColorRange", (Object)30);
        this.attributes.set("regionPx", (Object)0);
        this.attributes.set("regionPy", (Object)0);
        this.attributes.set("regionWidth", (Object)1);
        this.attributes.set("regionHeight", (Object)1);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        return null;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        this.image = a_imageIn;
        if (!this.targetPatternLoaded) {
            this.regionPx = (Integer)this.attributes.get("regionPx");
            this.regionPy = (Integer)this.attributes.get("regionPy");
            this.regionWidth = (Integer)this.attributes.get("regionWidth");
            this.regionHeight = (Integer)this.attributes.get("regionHeight");
            this.loadTargetPattern(this.regionPx, this.regionPy, this.regionWidth, this.regionHeight);
            this.targetPatternLoaded = true;
        } else {
            this.colorRange = (Integer)this.attributes.get("differenceColorRange");
            this.imageWidth = a_imageIn.getWidth();
            this.imageHeight = a_imageIn.getHeight();
            int[] l_arrRegion = new int[]{this.regionPx, this.regionPy, this.regionWidth, this.regionHeight};
            this.newRegion(l_arrRegion, this.regionWidth / 10, 0, 4);
            this.newRegion(l_arrRegion, this.regionWidth / 20, 0, 5);
            this.newRegion(l_arrRegion, 2, 0, 20);
            this.newRegionSize(l_arrRegion, 0, 8);
            this.regionPx = l_arrRegion[0];
            this.regionPy = l_arrRegion[1];
            this.regionWidth = l_arrRegion[2];
            this.regionHeight = l_arrRegion[3];
        }
        a_attributesOut.set("regionPx", (Object)this.regionPx);
        a_attributesOut.set("regionPy", (Object)this.regionPy);
        a_attributesOut.set("regionWidth", (Object)this.regionWidth);
        a_attributesOut.set("regionHeight", (Object)this.regionHeight);
    }

    private void loadTargetPattern(int a_x, int a_y, int a_width, int a_height) {
        this.regionPx = a_x;
        this.regionPy = a_y;
        this.regionWidth = a_width;
        this.regionHeight = a_height;
        this.patternWidth = a_width / 2;
        this.patternHeight = a_height / 2;
        this.arrTargetPattern = new int[this.patternWidth * this.patternHeight];
        this.arrTempPattern = new int[this.patternWidth * this.patternHeight];
        this.captureObject(this.regionPx, this.regionPy, this.regionWidth, this.regionHeight);
    }

    private void captureObject(int a_x, int a_y, int a_width, int a_height) {
        double l_xFactor = (double)a_width / (double)this.patternWidth;
        double l_yFactor = (double)a_height / (double)this.patternHeight;
        double l_dX = a_x;
        double l_dY = a_y;
        for (int l_h = 0; l_h < this.patternHeight; ++l_h) {
            l_dY += l_yFactor;
            for (int l_w = 0; l_w < this.patternWidth; ++l_w) {
                int l_iX = (int)(l_dX += l_xFactor);
                int l_iY = (int)l_dY;
                this.arrTargetPattern[l_h * this.patternWidth + l_w] = this.image.getIntColor(l_iX, l_iY);
            }
            l_dX = a_x;
        }
    }

    private void newRegion(int[] a_arrRegion, int a_pixelShift, int a_depth, int a_maxDepth) {
        double l_bestMatch = 0.0;
        int l_bestShiftX = 0;
        int l_bestShiftY = 0;
        double l_tempMatch = this.matchRegion(a_arrRegion[0] - a_pixelShift, a_arrRegion[1], a_arrRegion[2], a_arrRegion[3]);
        if (l_tempMatch > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = -a_pixelShift;
            l_bestShiftY = 0;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0] + a_pixelShift, a_arrRegion[1], a_arrRegion[2], a_arrRegion[3])) > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = a_pixelShift;
            l_bestShiftY = 0;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0], a_arrRegion[1] - a_pixelShift, a_arrRegion[2], a_arrRegion[3])) > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = 0;
            l_bestShiftY = -a_pixelShift;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0], a_arrRegion[1] + a_pixelShift, a_arrRegion[2], a_arrRegion[3])) > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = 0;
            l_bestShiftY = a_pixelShift;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0] - a_pixelShift, a_arrRegion[1] - a_pixelShift, a_arrRegion[2], a_arrRegion[3])) > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = -a_pixelShift;
            l_bestShiftY = -a_pixelShift;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0] - a_pixelShift, a_arrRegion[1] + a_pixelShift, a_arrRegion[2], a_arrRegion[3])) > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = -a_pixelShift;
            l_bestShiftY = a_pixelShift;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0] + a_pixelShift, a_arrRegion[1] - a_pixelShift, a_arrRegion[2], a_arrRegion[3])) > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = a_pixelShift;
            l_bestShiftY = -a_pixelShift;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0] + a_pixelShift, a_arrRegion[1] + a_pixelShift, a_arrRegion[2], a_arrRegion[3])) > l_bestMatch) {
            l_bestMatch = l_tempMatch;
            l_bestShiftX = a_pixelShift;
            l_bestShiftY = a_pixelShift;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0], a_arrRegion[1], a_arrRegion[2], a_arrRegion[3])) >= l_bestMatch) {
            return;
        }
        a_arrRegion[0] = a_arrRegion[0] + l_bestShiftX;
        a_arrRegion[1] = a_arrRegion[1] + l_bestShiftY;
        if (a_depth < a_maxDepth) {
            this.newRegion(a_arrRegion, a_pixelShift, a_depth + 1, a_maxDepth);
        }
    }

    private void newRegionSize(int[] a_arrRegion, int a_depth, int a_maxDepth) {
        double l_betterMatch = 0.0;
        int l_betterIndex = 0;
        int l_scaleS = (int)((double)a_arrRegion[2] * 0.05);
        int l_OriginShift = l_scaleS / 2;
        double l_tempMatch = this.matchRegion(a_arrRegion[0] - 3, a_arrRegion[1] - l_OriginShift, a_arrRegion[2] + l_scaleS, a_arrRegion[3] + l_scaleS);
        if (l_tempMatch > l_betterMatch) {
            l_betterMatch = l_tempMatch;
            l_betterIndex = 1;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0] + 3, a_arrRegion[1] + l_OriginShift, a_arrRegion[2] - l_scaleS, a_arrRegion[3] - l_scaleS)) > l_betterMatch) {
            l_betterMatch = l_tempMatch;
            l_betterIndex = 2;
        }
        if ((l_tempMatch = this.matchRegion(a_arrRegion[0], a_arrRegion[1], a_arrRegion[2], a_arrRegion[3])) >= l_betterMatch) {
            return;
        }
        switch (l_betterIndex) {
            case 1: {
                a_arrRegion[0] = a_arrRegion[0] - l_OriginShift;
                a_arrRegion[1] = a_arrRegion[1] - l_OriginShift;
                a_arrRegion[2] = a_arrRegion[2] + l_scaleS;
                a_arrRegion[3] = a_arrRegion[3] + l_scaleS;
                break;
            }
            case 2: {
                a_arrRegion[0] = a_arrRegion[0] + l_OriginShift;
                a_arrRegion[1] = a_arrRegion[1] + l_OriginShift;
                a_arrRegion[2] = a_arrRegion[2] - l_scaleS;
                a_arrRegion[3] = a_arrRegion[3] - l_scaleS;
            }
        }
        if (a_depth < a_maxDepth) {
            this.newRegionSize(a_arrRegion, a_depth + 1, a_maxDepth);
        }
    }

    private double matchRegion(int a_x, int a_y, int a_width, int a_height) {
        double l_xFactor = (double)a_width / (double)this.patternWidth;
        double l_yFactor = (double)a_height / (double)this.patternHeight;
        double l_dX = a_x;
        double l_dY = a_y;
        if (a_x < 0 || a_y < 0 || a_x + a_width + 1 > this.imageWidth || a_y + a_height + 1 > this.imageHeight) {
            return 0.0;
        }
        for (int l_h = 0; l_h < this.patternHeight; ++l_h) {
            l_dY += l_yFactor;
            for (int l_w = 0; l_w < this.patternWidth; ++l_w) {
                int l_iX = (int)(l_dX += l_xFactor);
                int l_iY = (int)l_dY;
                this.arrTempPattern[l_h * this.patternWidth + l_w] = this.image.getIntColor(l_iX, l_iY);
            }
            l_dX = a_x;
        }
        int l_diffPixels = 0;
        for (int l_h = 0; l_h < this.patternHeight; ++l_h) {
            for (int l_w = 0; l_w < this.patternWidth; ++l_w) {
                int l_redA = (this.arrTargetPattern[l_h * this.patternWidth + l_w] & 0xFF0000) >>> 16;
                int l_redB = (this.arrTempPattern[l_h * this.patternWidth + l_w] & 0xFF0000) >>> 16;
                int l_greenA = (this.arrTargetPattern[l_h * this.patternWidth + l_w] & 0xFF00) >>> 8;
                int l_greenB = (this.arrTempPattern[l_h * this.patternWidth + l_w] & 0xFF00) >>> 8;
                int l_blueA = this.arrTargetPattern[l_h * this.patternWidth + l_w] & 0xFF;
                int l_blueB = this.arrTempPattern[l_h * this.patternWidth + l_w] & 0xFF;
                if (Math.abs(l_redA - l_redB) <= this.colorRange && Math.abs(l_greenA - l_greenB) <= this.colorRange && Math.abs(l_blueA - l_blueB) <= this.colorRange) continue;
                ++l_diffPixels;
            }
        }
        return 100.0 - (double)l_diffPixels / (double)(this.patternWidth * this.patternHeight) * 100.0;
    }
}

