/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.render.lindenmayer;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.render.lindenmayer.Grammar;
import org.marvinproject.image.render.lindenmayer.TurtleGraphics;

public class Lindenmayer
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private Grammar grammar;
    private TurtleGraphics turtle;
    private String startText;
    private String RULES = "start->G\nG->F[-G][+G]FG\nF->FF\n";

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("rotationAngle", (Object)25.7);
        this.attributes.set("initialAngle", (Object)90.0);
        this.attributes.set("iterations", (Object)9);
        this.attributes.set("rules", (Object)this.RULES);
        this.attributes.set("initialText", (Object)"G");
        this.grammar = new Grammar();
        this.turtle = new TurtleGraphics();
    }

    public void process(MarvinImage imageIn, MarvinImage imageOut, MarvinAttributes out2, MarvinImageMask a_mask, boolean mode) {
        String[] rules = null;
        String strRules = (String)this.attributes.get("rules");
        if (strRules.contains("\n")) {
            rules = ((String)this.attributes.get("rules")).split("\n");
        } else if (strRules.contains("&")) {
            rules = ((String)this.attributes.get("rules")).split("&");
        }
        double initialAngle = (Double)this.attributes.get("initialAngle");
        double rotationAngle = (Double)this.attributes.get("rotationAngle");
        int iterations = (Integer)this.attributes.get("iterations");
        for (int i = 0; i < rules.length; ++i) {
            this.addRule(rules[i]);
        }
        this.turtle.setStartPosition(0, 0, initialAngle);
        this.turtle.setRotationAngle(rotationAngle);
        imageOut.clear(-1);
        this.turtle.render(this.startText, this.grammar, iterations, imageOut);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblIterations", "iterations:");
            this.attributesPanel.addTextField("txtIterations", "iterations", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblInitialAngle", "initialAngle:");
            this.attributesPanel.addTextField("txtInitialAngle", "initialAngle", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblRotationAngle", "rotationAngle:");
            this.attributesPanel.addTextField("txtRotationAngle", "rotationAngle", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblRules", "rules:");
            this.attributesPanel.addTextArea("txtRules", "rules", 8, 40, this.attributes);
        }
        return this.attributesPanel;
    }

    private void addRule(String rule) {
        String[] r = rule.split("->");
        if (r[0].equals("start")) {
            this.startText = r[1];
        } else {
            this.grammar.addRule(r[0], r[1]);
        }
    }
}

