/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.segmentation.imageSlicer;

import java.awt.image.RenderedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;
import marvin.util.MarvinErrorHandler;
import marvin.util.MarvinFileChooser;

public class ImageSlicer
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private MarvinPerformanceMeter performanceMeter;
    private DecimalFormat df = new DecimalFormat("000");

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("txtLines", (Object)1);
        this.attributes.set("txtCols", (Object)1);
        this.performanceMeter = new MarvinPerformanceMeter();
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        int conty = 0;
        int contx = 0;
        int conti = 0;
        int line = 0;
        int col = 0;
        int lines = Integer.parseInt(this.attributes.get("txtLines").toString());
        int cols = Integer.parseInt(this.attributes.get("txtCols").toString());
        int width = a_imageIn.getWidth();
        int height = a_imageIn.getHeight();
        int limitl = height / lines;
        int limitc = width / cols;
        if (!a_previewMode) {
            int x;
            ArrayList<MarvinImage> listaImgs = new ArrayList<MarvinImage>();
            for (x = 0; x < lines * cols; ++x) {
                listaImgs.add(new MarvinImage(limitc, limitl));
            }
            this.performanceMeter.enableProgressBar("Image Slicer", lines * cols * limitc * limitl);
            int y = 0;
            for (line = 0; line < lines; ++line) {
                for (col = 0; col < cols; ++col) {
                    for (x = line * limitl; x < (line + 1) * limitl; ++x) {
                        for (y = col * limitc; y < (col + 1) * limitc; ++y) {
                            int r = a_imageIn.getIntComponent0(y, x);
                            int g = a_imageIn.getIntComponent1(y, x);
                            int b = a_imageIn.getIntComponent2(y, x);
                            ((MarvinImage)listaImgs.get(conti)).setIntColor(conty, contx, r, g, b);
                            ++conty;
                            this.performanceMeter.incProgressBar(limitc);
                        }
                        conty = 0;
                        ++contx;
                        this.performanceMeter.incProgressBar(limitl);
                    }
                    ((MarvinImage)listaImgs.get(conti)).update();
                    conty = 0;
                    contx = 0;
                    ++conti;
                }
                conty = 0;
                contx = 0;
            }
            this.performanceMeter.finish();
            String arq = "";
            int foto = 0;
            try {
                arq = MarvinFileChooser.select(null, (boolean)false, (int)1);
                for (x = 0; x < lines; ++x) {
                    for (y = 0; y < cols; ++y) {
                        String prefix = arq.replaceAll(".jpg", "");
                        if (prefix == null) continue;
                        prefix = prefix + this.df.format(x + 1) + "x" + this.df.format(y + 1) + ".jpg";
                        File grava = new File(prefix);
                        ImageIO.write((RenderedImage)((MarvinImage)listaImgs.get(foto)).getBufferedImage(), "jpg", grava);
                        ++foto;
                    }
                }
            }
            catch (Exception e3) {
                MarvinErrorHandler.handleDialog((MarvinErrorHandler.TYPE)MarvinErrorHandler.TYPE.ERROR_FILE_SAVE, (Exception)e3);
            }
            if (arq != null) {
                JOptionPane.showMessageDialog(null, "Files saved successfully at: " + arq.replaceAll(".jpg", ""), "Marvin", 1);
            }
            a_imageOut.setIntColorArray(a_imageIn.getIntColorArray());
        } else {
            this.performanceMeter.enableProgressBar("Image Slicer", lines * cols * limitc * limitl);
            for (int y = 0; y < a_imageIn.getHeight(); ++y) {
                for (int x = 0; x < a_imageIn.getWidth(); ++x) {
                    if (x != 0 && x % limitc == 0 || y != 0 && y % limitl == 0) {
                        a_imageOut.setIntColor(x, y, 255, 0, 0);
                        continue;
                    }
                    a_imageOut.setIntColor(x, y, a_imageIn.getIntColor(x, y));
                }
                this.performanceMeter.incProgressBar(width - 2);
            }
            this.performanceMeter.finish();
        }
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblLinhas", "Number of rows:");
            this.attributesPanel.addTextField("txtLines", "txtLines", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblCols", "Number of columns:");
            this.attributesPanel.addTextField("txtCols", "txtCols", this.attributes);
            this.attributesPanel.newComponentRow();
        }
        return this.attributesPanel;
    }
}

