/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.statistical.median;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.performance.MarvinPerformanceMeter;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Median
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    MarvinAttributes attributes;
    MarvinPerformanceMeter performanceMeter;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("size", (Object)3);
        this.performanceMeter = new MarvinPerformanceMeter();
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean a_previewMode) {
        this.performanceMeter.start("Median Filter");
        int l_size = (Integer)this.attributes.get("size");
        int l_totalRed = 0;
        int l_totalGreen = 0;
        int l_totalBlue = 0;
        int qtd = 0;
        int tmpx = 0;
        int tmpy = 0;
        int width = a_imageIn.getWidth();
        int height = a_imageIn.getHeight();
        this.performanceMeter.enableProgressBar("Median Filter", a_imageIn.getWidth() * a_imageIn.getHeight());
        this.performanceMeter.startEvent("Median Filter");
        boolean[][] l_arrMask = a_mask.getMask();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (l_arrMask != null && !l_arrMask[x][y]) continue;
                tmpx = x - l_size;
                tmpy = y - l_size;
                if (tmpx < 0) {
                    tmpx = 0;
                }
                if (tmpy < 0) {
                    tmpy = 0;
                }
                int finalX = x + l_size;
                int finalY = y + l_size;
                if (finalX > width) {
                    finalX = width;
                }
                if (finalY > height) {
                    finalY = height;
                }
                for (int xm = tmpx; xm < finalX; ++xm) {
                    for (int ym = tmpy; ym < y + l_size; ++ym) {
                        if (xm < 0 || xm >= width || ym < 0 || ym >= height) continue;
                        int rgb = a_imageIn.getIntColor(xm, ym);
                        l_totalRed += (rgb & 0xFF0000) >>> 16;
                        l_totalGreen += (rgb & 0xFF00) >>> 8;
                        l_totalBlue += rgb & 0xFF;
                        ++qtd;
                    }
                }
                a_imageOut.setIntColor(x, y, a_imageIn.getAlphaComponent(x, y), l_totalRed / qtd, l_totalGreen / qtd, l_totalBlue / qtd);
                l_totalRed = 0;
                l_totalGreen = 0;
                l_totalBlue = 0;
                qtd = 0;
            }
            this.performanceMeter.incProgressBar(height);
            this.performanceMeter.stepsFinished(height);
        }
        this.performanceMeter.finishEvent();
        this.performanceMeter.finish();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblWidth", "Size:");
            this.attributesPanel.addTextField("txtSize", "size", this.attributes);
            this.attributesPanel.newComponentRow();
        }
        return this.attributesPanel;
    }
}

