/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.texture.tileTexture;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.plugin.MarvinImagePlugin;
import marvin.util.MarvinAttributes;
import org.marvinproject.image.transform.flip.Flip;

public class TileTexture
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private MarvinAttributes attributes;
    private MarvinImagePlugin flip;

    public void load() {
        this.attributes = this.getAttributes();
        this.attributes.set("tile", (Object)-1);
        this.attributes.set("lines", (Object)2);
        this.attributes.set("columns", (Object)2);
        this.flip = new Flip();
        this.flip.load();
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblLines", "lines");
            this.attributesPanel.addTextField("txtLines", "lines", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblColumns", "columns");
            this.attributesPanel.addTextField("txtColumns", "columns", this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage imgIn, MarvinImage imgOut, MarvinAttributes attrOut, MarvinImageMask mask, boolean previewMode) {
        int lines = (Integer)this.attributes.get("lines");
        int columns = (Integer)this.attributes.get("columns");
        MarvinImage tile = (MarvinImage)this.attributes.get("tile");
        int tileWidth = tile.getWidth();
        int tileHeight = tile.getHeight();
        boolean[][] arrMask = mask.getMask();
        if (arrMask != null) {
            MarvinImage.copyColorArray((MarvinImage)imgIn, (MarvinImage)imgOut);
        } else {
            imgOut.resize(tile.getWidth() * columns, tile.getHeight() * lines);
        }
        MarvinImage tileFlippedH = new MarvinImage(tileWidth, tileHeight);
        MarvinImage tileFlippedV = new MarvinImage(tileWidth, tileHeight);
        MarvinImage tileFlippedHV = new MarvinImage(tileWidth, tileHeight);
        this.flip.setAttribute("flip", (Object)"horizontal");
        this.flip.process(tile, tileFlippedH);
        this.flip.process(tile, tileFlippedHV);
        this.flip.setAttribute("flip", (Object)"vertical");
        this.flip.process(tile, tileFlippedV);
        this.flip.process(tileFlippedHV, tileFlippedHV);
        for (int y = 0; y < lines; ++y) {
            for (int x = 0; x < columns; ++x) {
                if (x % 2 == 0 && y % 2 == 0) {
                    this.copyImage(tile, imgOut, x * tileWidth, y * tileHeight, arrMask);
                    continue;
                }
                if (y % 2 == 0) {
                    this.copyImage(tileFlippedH, imgOut, x * tileWidth, y * tileHeight, arrMask);
                    continue;
                }
                if (x % 2 == 0) {
                    this.copyImage(tileFlippedV, imgOut, x * tileWidth, y * tileHeight, arrMask);
                    continue;
                }
                this.copyImage(tileFlippedHV, imgOut, x * tileWidth, y * tileHeight, arrMask);
            }
        }
    }

    private void copyImage(MarvinImage tile, MarvinImage imgOut, int x, int y, boolean[][] mask) {
        for (int j = 0; j < tile.getHeight(); ++j) {
            for (int i = 0; i < tile.getWidth(); ++i) {
                if (x + i >= imgOut.getWidth() || y + j >= imgOut.getHeight() || mask != null && !mask[x + i][y + j]) continue;
                imgOut.setIntColor(i + x, j + y, tile.getIntColor(i, j));
            }
        }
    }
}

