/*
 * Decompiled with CFR 0.152.
 */
package org.marvinproject.image.transform.scale;

import marvin.gui.MarvinAttributesPanel;
import marvin.image.MarvinImage;
import marvin.image.MarvinImageMask;
import marvin.plugin.MarvinAbstractImagePlugin;
import marvin.util.MarvinAttributes;

public class Scale
extends MarvinAbstractImagePlugin {
    private MarvinAttributesPanel attributesPanel;
    private int width;
    private int height;
    private int newWidth;
    private int newHeight;
    private MarvinAttributes attributes;

    public void load() {
        this.attributes = this.getAttributes();
        this.newWidth = 0;
        this.newHeight = 0;
        this.attributes.set("newWidth", (Object)this.newWidth);
        this.attributes.set("newHeight", (Object)this.newHeight);
    }

    public MarvinAttributesPanel getAttributesPanel() {
        if (this.attributesPanel == null) {
            this.attributesPanel = new MarvinAttributesPanel();
            this.attributesPanel.addLabel("lblWidth", "Width:");
            this.attributesPanel.addTextField("txtWidth", "newWidth", this.attributes);
            this.attributesPanel.newComponentRow();
            this.attributesPanel.addLabel("lblHeight", "Height:");
            this.attributesPanel.addTextField("txtHeight", "newHeight", this.attributes);
        }
        return this.attributesPanel;
    }

    public void process(MarvinImage a_imageIn, MarvinImage a_imageOut, MarvinAttributes a_attributesOut, MarvinImageMask a_mask, boolean previewMode) {
        if (!previewMode) {
            this.width = a_imageIn.getWidth();
            this.height = a_imageIn.getHeight();
            this.newWidth = (Integer)this.attributes.get("newWidth");
            this.newHeight = (Integer)this.attributes.get("newHeight");
            if (a_imageOut.getWidth() != this.newWidth || a_imageOut.getHeight() != this.newHeight) {
                a_imageOut.setDimension(this.newWidth, this.newHeight);
            }
            int x_ratio = (this.width << 16) / this.newWidth;
            int y_ratio = (this.height << 16) / this.newHeight;
            for (int i = 0; i < this.newHeight; ++i) {
                for (int j = 0; j < this.newWidth; ++j) {
                    int x2 = j * x_ratio >> 16;
                    int y2 = i * y_ratio >> 16;
                    a_imageOut.setIntColor(j, i, a_imageIn.getAlphaComponent(x2, y2), a_imageIn.getIntColor(x2, y2));
                }
            }
        }
    }
}

