/*
 * Decompiled with CFR 0.152.
 */
package com.github.doyaaaaaken.kotlincsv.client;

import com.github.doyaaaaaken.kotlincsv.client.BufferedLineReader;
import com.github.doyaaaaaken.kotlincsv.client.CsvFileReader;
import com.github.doyaaaaaken.kotlincsv.dsl.context.CsvReaderContext;
import com.github.doyaaaaaken.kotlincsv.parser.CsvParser;
import com.github.doyaaaaaken.kotlincsv.util.CSVFieldNumDifferentException;
import com.github.doyaaaaaken.kotlincsv.util.MalformedCSVException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00130\u0015J\u0018\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00170\u0015J\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0013J\u001b\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00132\b\b\u0002\u0010\u001a\u001a\u00020\u0011H\u0082\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/doyaaaaaken/kotlincsv/client/CsvFileReader;", "Ljava/io/Closeable;", "ctx", "Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvReaderContext;", "reader", "Ljava/io/BufferedReader;", "(Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvReaderContext;Ljava/io/BufferedReader;)V", "logger", "Lmu/KLogger;", "parser", "Lcom/github/doyaaaaaken/kotlincsv/parser/CsvParser;", "Lcom/github/doyaaaaaken/kotlincsv/client/BufferedLineReader;", "rowNum", "", "close", "", "findDuplicate", "", "headers", "", "readAllAsSequence", "Lkotlin/sequences/Sequence;", "readAllWithHeaderAsSequence", "", "readNext", "readUntilNextCsvRow", "leftOver", "kotlin-csv"})
public final class CsvFileReader
implements Closeable {
    private final KLogger logger;
    private final BufferedLineReader reader;
    private long rowNum;
    private final CsvParser parser;
    private final CsvReaderContext ctx;

    @Nullable
    public final List<String> readNext() {
        return this.readUntilNextCsvRow("");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Sequence<List<String>> readAllAsSequence() {
        void fieldsNum;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        return SequencesKt.mapIndexedNotNull((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ CsvFileReader this$0;

            @Nullable
            public final List<String> invoke() {
                return this.this$0.readNext();
            }
            {
                this.this$0 = csvFileReader;
                super(0);
            }
        })), (Function2)((Function2)new Function2<Integer, List<? extends String>, List<? extends String>>(this, (Ref.ObjectRef)fieldsNum){
            final /* synthetic */ CsvFileReader this$0;
            final /* synthetic */ Ref.ObjectRef $fieldsNum;

            @Nullable
            public final List<String> invoke(int idx, @NotNull List<String> row) {
                List list;
                Intrinsics.checkParameterIsNotNull(row, (String)"row");
                if ((Integer)this.$fieldsNum.element == null) {
                    this.$fieldsNum.element = row.size();
                }
                Integer n = (Integer)this.$fieldsNum.element;
                int n2 = row.size();
                if (n == null || n != n2) {
                    if (!CsvFileReader.access$getCtx$p(this.this$0).getSkipMissMatchedRow()) {
                        Integer n3 = (Integer)this.$fieldsNum.element;
                        boolean bl = false;
                        boolean bl2 = false;
                        bl2 = false;
                        boolean bl3 = false;
                        if (n3 == null) {
                            boolean bl4 = false;
                            String string = "Required value was null.";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        Integer n4 = n3;
                        int n5 = idx + 1;
                        int n6 = row.size();
                        int n7 = ((Number)n4).intValue();
                        throw (Throwable)new CSVFieldNumDifferentException(n7, n6, n5);
                    }
                    CsvFileReader.access$getLogger$p(this.this$0).info("skip miss matched row. [csv row num = " + (idx + 1) + ", fields num = " + row.size() + ", fields num of first row = " + (Integer)this.$fieldsNum.element + ']');
                    list = null;
                } else {
                    list = row;
                }
                return list;
            }
            {
                this.this$0 = csvFileReader;
                this.$fieldsNum = objectRef;
                super(2);
            }
        }));
    }

    @NotNull
    public final Sequence<Map<String, String>> readAllWithHeaderAsSequence() {
        List<String> list = this.readNext();
        if (list == null) {
            return SequencesKt.emptySequence();
        }
        List<String> headers = list;
        String duplicated = this.findDuplicate(headers);
        if (duplicated != null) {
            throw (Throwable)new MalformedCSVException("header '" + duplicated + "' is duplicated");
        }
        return SequencesKt.map(this.readAllAsSequence(), (Function1)((Function1)new Function1<List<? extends String>, Map<String, ? extends String>>(headers){
            final /* synthetic */ List $headers;

            @NotNull
            public final Map<String, String> invoke(@NotNull List<String> fields) {
                Intrinsics.checkParameterIsNotNull(fields, (String)"fields");
                return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.$headers, (Iterable)fields));
            }
            {
                this.$headers = list;
                super(1);
            }
        }));
    }

    @Override
    public void close() {
        this.reader.close();
    }

    private final List<String> readUntilNextCsvRow(String leftOver) {
        List<String> list;
        while (true) {
            String nextLine = this.reader.readLineWithTerminator();
            long l = this.rowNum;
            this.rowNum = l + 1L;
            if (nextLine == null) {
                CharSequence charSequence = leftOver;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    throw (Throwable)new MalformedCSVException('\"' + leftOver + "\" on the tail of file is left on the way of parsing row");
                }
                list = null;
                break;
            }
            if (this.ctx.getSkipEmptyLine() && StringsKt.isBlank((CharSequence)nextLine) && StringsKt.isBlank((CharSequence)leftOver)) continue;
            CharSequence charSequence = leftOver;
            boolean bl = false;
            String value = charSequence.length() == 0 ? String.valueOf(nextLine) : leftOver + nextLine;
            list = this.parser.parseRow(value, this.rowNum);
            if (list != null) break;
            leftOver = leftOver + nextLine;
        }
        return list;
    }

    static /* synthetic */ List readUntilNextCsvRow$default(CsvFileReader csvFileReader, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return csvFileReader.readUntilNextCsvRow(string);
    }

    private final String findDuplicate(List<String> headers) {
        boolean bl = false;
        Set set = new LinkedHashSet();
        Iterable $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String h = (String)element$iv;
            boolean bl2 = false;
            if (set.contains(h)) {
                return h;
            }
            set.add(h);
        }
        return null;
    }

    public CsvFileReader(@NotNull CsvReaderContext ctx, @NotNull BufferedReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.ctx = ctx;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.reader = new BufferedLineReader(reader);
        this.parser = new CsvParser(this.ctx.getQuoteChar(), this.ctx.getDelimiter(), this.ctx.getEscapeChar());
    }

    public static final /* synthetic */ CsvReaderContext access$getCtx$p(CsvFileReader $this) {
        return $this.ctx;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(CsvFileReader $this) {
        return $this.logger;
    }
}

