/*
 * Decompiled with CFR 0.152.
 */
package com.github.doyaaaaaken.kotlincsv.client;

import com.github.doyaaaaaken.kotlincsv.client.BufferedLineReader;
import com.github.doyaaaaaken.kotlincsv.client.CsvFileReader;
import com.github.doyaaaaaken.kotlincsv.client.Reader;
import com.github.doyaaaaaken.kotlincsv.dsl.context.CsvReaderContext;
import com.github.doyaaaaaken.kotlincsv.parser.CsvParser;
import com.github.doyaaaaaken.kotlincsv.util.CSVFieldNumDifferentException;
import com.github.doyaaaaaken.kotlincsv.util.MalformedCSVException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J#\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00130\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u001a0\u0015J\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0013J\u001b\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00132\b\b\u0002\u0010\u001d\u001a\u00020\u0011H\u0082\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/doyaaaaaken/kotlincsv/client/CsvFileReader;", "", "ctx", "Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvReaderContext;", "reader", "Lcom/github/doyaaaaaken/kotlincsv/client/Reader;", "(Lcom/github/doyaaaaaken/kotlincsv/dsl/context/CsvReaderContext;Lcom/github/doyaaaaaken/kotlincsv/client/Reader;)V", "logger", "Lmu/KLogger;", "parser", "Lcom/github/doyaaaaaken/kotlincsv/parser/CsvParser;", "Lcom/github/doyaaaaaken/kotlincsv/client/BufferedLineReader;", "rowNum", "", "close", "", "findDuplicate", "", "headers", "", "readAllAsSequence", "Lkotlin/sequences/Sequence;", "fieldsNum", "", "(Ljava/lang/Integer;)Lkotlin/sequences/Sequence;", "readAllWithHeaderAsSequence", "", "readNext", "readUntilNextCsvRow", "leftOver", "kotlin-csv"})
public final class CsvFileReader {
    @NotNull
    private final CsvReaderContext ctx;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final BufferedLineReader reader;
    private long rowNum;
    @NotNull
    private final CsvParser parser;

    public CsvFileReader(@NotNull CsvReaderContext ctx, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.ctx = ctx;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.reader = new BufferedLineReader(reader);
        this.parser = new CsvParser(this.ctx.getQuoteChar(), this.ctx.getDelimiter(), this.ctx.getEscapeChar());
    }

    @Nullable
    public final List<String> readNext() {
        return this.readUntilNextCsvRow("");
    }

    @NotNull
    public final Sequence<List<String>> readAllAsSequence(@Nullable Integer fieldsNum) {
        Ref.ObjectRef fieldsNumInRow = new Ref.ObjectRef();
        fieldsNumInRow.element = fieldsNum;
        return SequencesKt.mapIndexedNotNull((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ CsvFileReader this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final List<String> invoke() {
                return this.this$0.readNext();
            }
        })), (Function2)((Function2)new Function2<Integer, List<? extends String>, List<? extends String>>((Ref.ObjectRef<Integer>)fieldsNumInRow, this){
            final /* synthetic */ Ref.ObjectRef<Integer> $fieldsNumInRow;
            final /* synthetic */ CsvFileReader this$0;
            {
                this.$fieldsNumInRow = $fieldsNumInRow;
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final List<String> invoke(int idx, @NotNull List<String> row) {
                List list;
                Intrinsics.checkNotNullParameter(row, (String)"row");
                if (this.$fieldsNumInRow.element == null) {
                    this.$fieldsNumInRow.element = row.size();
                }
                Integer n = (Integer)this.$fieldsNumInRow.element;
                int n2 = row.size();
                if (n == null || n != n2) {
                    if (!CsvFileReader.access$getCtx$p(this.this$0).getSkipMissMatchedRow()) {
                        Object object = this.$fieldsNumInRow.element;
                        boolean bl = false;
                        boolean bl2 = false;
                        bl2 = false;
                        boolean bl3 = false;
                        if (object == null) {
                            boolean bl4 = false;
                            String string = "Required value was null.";
                            throw (Throwable)new IllegalArgumentException(string.toString());
                        }
                        throw new CSVFieldNumDifferentException(((Number)object).intValue(), row.size(), idx + 1);
                    }
                    CsvFileReader.access$getLogger$p(this.this$0).info((Function0)new Function0<Object>(idx, row, this.$fieldsNumInRow){
                        final /* synthetic */ int $idx;
                        final /* synthetic */ List<String> $row;
                        final /* synthetic */ Ref.ObjectRef<Integer> $fieldsNumInRow;
                        {
                            this.$idx = $idx;
                            this.$row = $row;
                            this.$fieldsNumInRow = $fieldsNumInRow;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "skip miss matched row. [csv row num = " + (this.$idx + 1) + ", fields num = " + this.$row.size() + ", fields num of first row = " + this.$fieldsNumInRow.element + ']';
                        }
                    });
                    list = (List)((Object)((Void)null));
                } else {
                    list = row;
                }
                return list;
            }
        }));
    }

    public static /* synthetic */ Sequence readAllAsSequence$default(CsvFileReader csvFileReader, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return csvFileReader.readAllAsSequence(n);
    }

    @NotNull
    public final Sequence<Map<String, String>> readAllWithHeaderAsSequence() {
        List<String> list = this.readNext();
        if (list == null) {
            return SequencesKt.emptySequence();
        }
        List<String> headers = list;
        String duplicated = this.findDuplicate(headers);
        if (duplicated != null) {
            throw new MalformedCSVException("header '" + duplicated + "' is duplicated");
        }
        return SequencesKt.map(this.readAllAsSequence(headers.size()), (Function1)((Function1)new Function1<List<? extends String>, Map<String, ? extends String>>(headers){
            final /* synthetic */ List<String> $headers;
            {
                this.$headers = $headers;
                super(1);
            }

            @NotNull
            public final Map<String, String> invoke(@NotNull List<String> fields) {
                Intrinsics.checkNotNullParameter(fields, (String)"fields");
                return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)this.$headers, (Iterable)fields));
            }
        }));
    }

    public final void close() {
        this.reader.close();
    }

    private final List<String> readUntilNextCsvRow(String leftOver) {
        Object object;
        block4: {
            Object object2;
            CsvFileReader csvFileReader = this;
            String string = leftOver;
            while (true) {
                CsvFileReader csvFileReader2 = csvFileReader;
                String string2 = string;
                String nextLine = csvFileReader2.reader.readLineWithTerminator();
                Object object3 = csvFileReader2;
                long l = ((CsvFileReader)object3).rowNum;
                ((CsvFileReader)object3).rowNum = l + 1L;
                if (nextLine == null) {
                    object3 = string2;
                    boolean bl = false;
                    if (object3.length() > 0) {
                        throw new MalformedCSVException('\"' + string2 + "\" on the tail of file is left on the way of parsing row");
                    }
                    object = (List)((Object)((Void)null));
                    break block4;
                }
                if (csvFileReader2.ctx.getSkipEmptyLine() && StringsKt.isBlank((CharSequence)nextLine) && StringsKt.isBlank((CharSequence)string2)) {
                    csvFileReader = csvFileReader2;
                    string = string2;
                    continue;
                }
                object2 = string2;
                boolean bl = false;
                String value = object2.length() == 0 ? String.valueOf(nextLine) : Intrinsics.stringPlus((String)string2, (Object)nextLine);
                if ((object2 = csvFileReader2.parser.parseRow(value, csvFileReader2.rowNum)) != null) break;
                csvFileReader = csvFileReader2;
                string = Intrinsics.stringPlus((String)string2, (Object)nextLine);
            }
            object = object2;
        }
        return object;
    }

    static /* synthetic */ List readUntilNextCsvRow$default(CsvFileReader csvFileReader, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return csvFileReader.readUntilNextCsvRow(string);
    }

    private final String findDuplicate(List<String> headers) {
        boolean bl = false;
        Set set = new LinkedHashSet();
        Iterable $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String h = (String)element$iv;
            boolean bl2 = false;
            if (set.contains(h)) {
                return h;
            }
            set.add(h);
        }
        return null;
    }

    public static final /* synthetic */ CsvReaderContext access$getCtx$p(CsvFileReader $this) {
        return $this.ctx;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(CsvFileReader $this) {
        return $this.logger;
    }
}

