/*
 * Decompiled with CFR 0.152.
 */
package com.github.doyaaaaaken.kotlincsv.parser;

import com.github.doyaaaaaken.kotlincsv.parser.ParseState;
import com.github.doyaaaaaken.kotlincsv.util.CSVParseFormatException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0016J%\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/github/doyaaaaaken/kotlincsv/parser/ParseStateMachine;", "", "quoteChar", "", "delimiter", "escapeChar", "(CCC)V", "BOM", "field", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fields", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "pos", "", "state", "Lcom/github/doyaaaaaken/kotlincsv/parser/ParseState;", "flushField", "", "getResult", "", "read", "ch", "nextCh", "rowNum", "(CLjava/lang/Character;J)J", "kotlin-csv"})
public final class ParseStateMachine {
    private final char quoteChar;
    private final char delimiter;
    private final char escapeChar;
    private final char BOM;
    @NotNull
    private ParseState state;
    @NotNull
    private final ArrayList<String> fields;
    @NotNull
    private StringBuilder field;
    private long pos;

    public ParseStateMachine(char quoteChar, char delimiter, char escapeChar) {
        this.quoteChar = quoteChar;
        this.delimiter = delimiter;
        this.escapeChar = escapeChar;
        this.BOM = (char)65279;
        this.state = ParseState.START;
        this.fields = new ArrayList();
        this.field = new StringBuilder();
    }

    public final long read(char ch, @Nullable Character nextCh, long rowNum) {
        long prevPos = this.pos++;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                char c = ch;
                if (c != this.BOM) {
                    if (c == this.quoteChar) {
                        this.state = ParseState.QUOTE_START;
                    } else if (c == this.delimiter) {
                        this.flushField();
                        this.state = ParseState.DELIMITER;
                    } else if (((c == '\n' ? true : c == '\u2028') ? true : c == '\u2029') ? true : c == '\u0085') {
                        this.flushField();
                        this.state = ParseState.END;
                    } else if (c == '\r') {
                        Character c2 = nextCh;
                        char c3 = '\n';
                        if (c2 != null && c2.charValue() == c3) {
                            ++this.pos;
                        }
                        this.flushField();
                        this.state = ParseState.END;
                    } else {
                        this.field.append(ch);
                        this.state = ParseState.FIELD;
                    }
                }
                ++this.pos;
                break;
            }
            case 2: {
                char c = ch;
                if (c == this.escapeChar) {
                    Character c4 = nextCh;
                    char c5 = this.escapeChar;
                    if (c4 == null || c4.charValue() != c5) {
                        throw new CSVParseFormatException(rowNum, this.pos, ch, "must appear escapeChar(" + this.escapeChar + ") after escapeChar(" + this.escapeChar + ')');
                    }
                    this.field.append(nextCh.charValue());
                    this.state = ParseState.FIELD;
                } else if (c == this.delimiter) {
                    this.flushField();
                    this.state = ParseState.DELIMITER;
                } else if (((c == '\n' ? true : c == '\u2028') ? true : c == '\u2029') ? true : c == '\u0085') {
                    this.flushField();
                    this.state = ParseState.END;
                } else if (c == '\r') {
                    Character c6 = nextCh;
                    char c7 = '\n';
                    if (c6 != null && c6.charValue() == c7) {
                        ++this.pos;
                    }
                    this.flushField();
                    this.state = ParseState.END;
                } else {
                    this.field.append(ch);
                    this.state = ParseState.FIELD;
                }
                ++this.pos;
                break;
            }
            case 3: {
                char c = ch;
                if (c == this.quoteChar) {
                    this.state = ParseState.QUOTE_START;
                } else if (c == this.delimiter) {
                    this.flushField();
                    this.state = ParseState.DELIMITER;
                } else if (((c == '\n' ? true : c == '\u2028') ? true : c == '\u2029') ? true : c == '\u0085') {
                    this.flushField();
                    this.state = ParseState.END;
                } else if (c == '\r') {
                    Character c8 = nextCh;
                    char c9 = '\n';
                    if (c8 != null && c8.charValue() == c9) {
                        ++this.pos;
                    }
                    this.flushField();
                    this.state = ParseState.END;
                } else {
                    this.field.append(ch);
                    this.state = ParseState.FIELD;
                }
                ++this.pos;
                break;
            }
            case 4: 
            case 5: {
                if (ch == this.escapeChar && this.escapeChar != this.quoteChar) {
                    if (nextCh == null) {
                        throw new CSVParseFormatException(rowNum, this.pos, ch, "end of quote doesn't exist");
                    }
                    char c = this.escapeChar;
                    if (nextCh.charValue() != c) {
                        c = this.quoteChar;
                        if (nextCh.charValue() != c) {
                            throw new CSVParseFormatException(rowNum, this.pos, ch, "escape character must appear consecutively twice");
                        }
                    }
                    this.field.append(nextCh.charValue());
                    this.state = ParseState.QUOTED_FIELD;
                    ++this.pos;
                } else if (ch == this.quoteChar) {
                    Character c = nextCh;
                    char c10 = this.quoteChar;
                    if (c != null && c.charValue() == c10) {
                        this.field.append(this.quoteChar);
                        this.state = ParseState.QUOTED_FIELD;
                        ++this.pos;
                    } else {
                        this.state = ParseState.QUOTE_END;
                    }
                } else {
                    this.field.append(ch);
                    this.state = ParseState.QUOTED_FIELD;
                }
                ++this.pos;
                break;
            }
            case 6: {
                char c = ch;
                if (c == this.delimiter) {
                    this.flushField();
                    this.state = ParseState.DELIMITER;
                } else if (((c == '\n' ? true : c == '\u2028') ? true : c == '\u2029') ? true : c == '\u0085') {
                    this.flushField();
                    this.state = ParseState.END;
                } else if (c == '\r') {
                    Character c11 = nextCh;
                    char c12 = '\n';
                    if (c11 != null && c11.charValue() == c12) {
                        ++this.pos;
                    }
                    this.flushField();
                    this.state = ParseState.END;
                } else {
                    throw new CSVParseFormatException(rowNum, this.pos, ch, "must appear delimiter or line terminator after quote end");
                }
                ++this.pos;
                break;
            }
            case 7: {
                throw new CSVParseFormatException(rowNum, this.pos, ch, "unexpected error");
            }
        }
        return this.pos - prevPos;
    }

    @Nullable
    public final List<String> getResult() {
        List list;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 3: {
                this.fields.add("");
                list = CollectionsKt.toList((Iterable)this.fields);
                break;
            }
            case 5: {
                list = null;
                break;
            }
            case 2: 
            case 6: {
                this.fields.add(this.field.toString());
                list = CollectionsKt.toList((Iterable)this.fields);
                break;
            }
            default: {
                list = CollectionsKt.toList((Iterable)this.fields);
            }
        }
        return list;
    }

    private final void flushField() {
        this.fields.add(this.field.toString());
        StringsKt.clear((StringBuilder)this.field);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParseState.values().length];
            nArray[ParseState.START.ordinal()] = 1;
            nArray[ParseState.FIELD.ordinal()] = 2;
            nArray[ParseState.DELIMITER.ordinal()] = 3;
            nArray[ParseState.QUOTE_START.ordinal()] = 4;
            nArray[ParseState.QUOTED_FIELD.ordinal()] = 5;
            nArray[ParseState.QUOTE_END.ordinal()] = 6;
            nArray[ParseState.END.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

