/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.MultiCombinationGenerator;

class MultiCombinationIterator<T>
implements Iterator<List<T>> {
    private final MultiCombinationGenerator<T> generator;
    private final int lengthN;
    private final int lengthK;
    private final List<T> currentCombination;
    private long currentIndex;
    private final int[] bitVector;
    private boolean end;

    MultiCombinationIterator(MultiCombinationGenerator<T> generator) {
        this.generator = generator;
        this.lengthN = generator.originalVector.size();
        this.currentCombination = new ArrayList<T>();
        this.bitVector = new int[generator.combinationLength];
        this.lengthK = generator.combinationLength - 1;
        for (int i = 0; i < generator.combinationLength; ++i) {
            this.bitVector[i] = 0;
        }
        this.end = false;
        this.currentIndex = 0L;
    }

    private static <T> void setValue(List<T> list, int index, T value) {
        if (index < list.size()) {
            list.set(index, value);
        } else {
            list.add(index, value);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.end;
    }

    @Override
    public List<T> next() {
        ++this.currentIndex;
        for (int i = 0; i < this.generator.combinationLength; ++i) {
            int index = this.bitVector[i];
            if (this.generator.originalVector.size() <= 0) continue;
            MultiCombinationIterator.setValue(this.currentCombination, i, this.generator.originalVector.get(index));
        }
        if (this.bitVector.length > 0) {
            int n = this.lengthK;
            this.bitVector[n] = this.bitVector[n] + 1;
            if (this.bitVector[this.lengthK] > this.lengthN - 1) {
                int index = -1;
                for (int i = 1; i <= this.bitVector.length; ++i) {
                    if (this.lengthK - i < 0 || this.bitVector[this.lengthK - i] >= this.lengthN - 1) continue;
                    index = this.lengthK - i;
                    break;
                }
                if (index != -1) {
                    int n2 = index;
                    this.bitVector[n2] = this.bitVector[n2] + 1;
                    for (int j = 1; j < this.bitVector.length - index; ++j) {
                        this.bitVector[index + j] = this.bitVector[index];
                    }
                } else {
                    this.end = true;
                }
            }
        } else {
            this.end = true;
        }
        return new ArrayList<T>(this.currentCombination);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "MultiCombinationIterator=[#" + this.currentIndex + ", " + this.currentCombination + "]";
    }
}

