/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.SimpleSubSetGenerator;

class SimpleSubSetIterator<T>
implements Iterator<List<T>> {
    private final SimpleSubSetGenerator<T> generator;
    private final int length;
    private final List<T> currentSubSet;
    private long currentIndex;
    private final int[] bitVector;

    SimpleSubSetIterator(SimpleSubSetGenerator<T> generator) {
        this.generator = generator;
        this.length = generator.originalVector.size();
        this.currentSubSet = new ArrayList<T>();
        this.bitVector = new int[this.length + 2];
        this.currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.bitVector[this.length + 1] != 1;
    }

    @Override
    public List<T> next() {
        ++this.currentIndex;
        this.currentSubSet.clear();
        for (int index = 1; index <= this.length; ++index) {
            if (this.bitVector[index] != 1) continue;
            Object value = this.generator.originalVector.get(index - 1);
            this.currentSubSet.add(value);
        }
        int i = 1;
        while (this.bitVector[i] == 1) {
            this.bitVector[i] = 0;
            ++i;
        }
        this.bitVector[i] = 1;
        return new ArrayList<T>(this.currentSubSet);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SimpleSubSetIterator=[#" + this.currentIndex + ", " + this.currentSubSet + "]";
    }
}

