/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.MultiCombinationGenerator;

class MultiCombinationIterator<T>
implements Iterator<List<T>> {
    private final MultiCombinationGenerator<T> generator;
    private final List<T> currentCombination = new ArrayList<T>();
    private final int[] bitVector;
    private long currentIndex;
    private boolean isEnd;

    MultiCombinationIterator(MultiCombinationGenerator<T> generator) {
        this.generator = generator;
        this.bitVector = new int[generator.combinationLength];
        for (int i = 0; i < generator.combinationLength; ++i) {
            this.bitVector[i] = 0;
        }
        this.isEnd = false;
        this.currentIndex = 0L;
    }

    private void setValue(int index, T value) {
        if (index < this.currentCombination.size()) {
            this.currentCombination.set(index, value);
        } else {
            this.currentCombination.add(index, value);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.isEnd;
    }

    @Override
    public List<T> next() {
        int combinationLength;
        int index;
        ++this.currentIndex;
        if (this.bitVector.length == 0) {
            this.isEnd = true;
            return new ArrayList<T>(this.currentCombination);
        }
        int size = this.generator.originalVector.size();
        for (int i = 0; i < this.generator.combinationLength; ++i) {
            index = this.bitVector[i];
            if (size <= 0) continue;
            this.setValue(i, this.generator.originalVector.get(index));
        }
        int n = combinationLength = this.generator.combinationLength - 1;
        this.bitVector[n] = this.bitVector[n] + 1;
        if (this.bitVector[combinationLength] > size - 1) {
            index = -1;
            for (int i = 1; i <= this.bitVector.length; ++i) {
                if (combinationLength - i < 0 || this.bitVector[combinationLength - i] >= size - 1) continue;
                index = combinationLength - i;
                break;
            }
            if (index != -1) {
                int n2 = index;
                this.bitVector[n2] = this.bitVector[n2] + 1;
                for (int j = 1; j < this.bitVector.length - index; ++j) {
                    this.bitVector[index + j] = this.bitVector[index];
                }
            } else {
                this.isEnd = true;
            }
        }
        return new ArrayList<T>(this.currentCombination);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "MultiCombinationIterator=[#" + this.currentIndex + ", " + this.currentCombination + "]";
    }
}

