/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.github.dreamhead.moco.CookieAttribute;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoRecorders;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.ResponseElement;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AndResponseHandler;
import com.github.dreamhead.moco.parser.ResponseHandlerFactory;
import com.github.dreamhead.moco.parser.model.AttachmentSetting;
import com.github.dreamhead.moco.parser.model.BaseResourceSetting;
import com.github.dreamhead.moco.parser.model.CollectionContainer;
import com.github.dreamhead.moco.parser.model.Container;
import com.github.dreamhead.moco.parser.model.CookieContainer;
import com.github.dreamhead.moco.parser.model.Dynamics;
import com.github.dreamhead.moco.parser.model.FileContainer;
import com.github.dreamhead.moco.parser.model.LatencyContainer;
import com.github.dreamhead.moco.parser.model.ProxyContainer;
import com.github.dreamhead.moco.parser.model.ReplayContainer;
import com.github.dreamhead.moco.parser.model.ResponseSetting;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.recorder.RecorderConfig;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.util.Iterables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class DynamicResponseHandlerFactory
extends Dynamics
implements ResponseHandlerFactory {
    private static final ImmutableSet<String> RESOURCES = ImmutableSet.of((Object)"text", (Object)"file", (Object)"pathResource", (Object)"version");
    private static final ImmutableMap<String, String> COMPOSITES = ImmutableMap.builder().put((Object)"headers", (Object)"header").put((Object)"cookies", (Object)"cookie").build();

    @Override
    public ResponseHandler createResponseHandler(ResponseSetting responseSetting) {
        List<ResponseHandler> handlers = StreamSupport.stream(this.getFields(responseSetting.getClass()).spliterator(), false).filter(this.isValidField(responseSetting)).map(this.fieldToResponseHandler(responseSetting)).collect(Collectors.toList());
        return this.getResponseHandler(handlers);
    }

    private ResponseHandler getResponseHandler(List<ResponseHandler> handlers) {
        if (handlers.size() == 1) {
            return handlers.get(0);
        }
        return AndResponseHandler.and(handlers);
    }

    private boolean isResource(String name) {
        return RESOURCES.contains((Object)name);
    }

    private Function<Field, ResponseHandler> fieldToResponseHandler(ResponseSetting response) {
        return field -> {
            try {
                Object value = field.get(response);
                return this.createResponseHandler(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private ResponseHandler createResponseHandler(String name, Object value) {
        if ("json".equalsIgnoreCase(name)) {
            return Moco.with((ResponseElement)Moco.json((Object)value));
        }
        if (this.isResource(name) && value instanceof TextContainer) {
            TextContainer container = (TextContainer)value;
            return Moco.with((ResponseElement)this.resourceFrom(name, container));
        }
        if (value instanceof Map) {
            return this.createCompositeHandler(name, this.castToMap(value));
        }
        if ("status".equalsIgnoreCase(name)) {
            return Moco.status((int)Integer.parseInt(value.toString()));
        }
        if ("latency".equalsIgnoreCase(name)) {
            LatencyContainer container = (LatencyContainer)value;
            return Moco.with((ResponseElement)container.asProcedure());
        }
        if (value instanceof ProxyContainer) {
            return ((ProxyContainer)value).asResponseHandler();
        }
        if ("attachment".equalsIgnoreCase(name)) {
            AttachmentSetting attachment = (AttachmentSetting)value;
            return Moco.attachment((String)attachment.getFilename(), (Resource)this.resourceFrom(attachment));
        }
        if ("seq".equalsIgnoreCase(name)) {
            CollectionContainer sequence = (CollectionContainer)value;
            Object[] responseHandlers = sequence.toResponseHandlers();
            return Moco.seq((ResponseHandler)((ResponseHandler)Iterables.head((Object[])responseHandlers)), (ResponseHandler[])((ResponseHandler[])Iterables.tail((Object[])responseHandlers)));
        }
        if ("cycle".equalsIgnoreCase(name)) {
            CollectionContainer sequence = (CollectionContainer)value;
            Object[] responseHandlers = sequence.toResponseHandlers();
            return Moco.cycle((ResponseHandler)((ResponseHandler)Iterables.head((Object[])responseHandlers)), (ResponseHandler[])((ResponseHandler[])Iterables.tail((Object[])responseHandlers)));
        }
        if ("record".equalsIgnoreCase(name)) {
            ReplayContainer container = (ReplayContainer)value;
            Object[] configs = container.getConfigs();
            return MocoRecorders.record((RecorderConfig)((RecorderConfig)Iterables.head((Object[])configs)), (RecorderConfig[])((RecorderConfig[])Iterables.tail((Object[])configs)));
        }
        if ("replay".equalsIgnoreCase(name)) {
            ReplayContainer container = (ReplayContainer)value;
            Object[] configs = container.getConfigs();
            return MocoRecorders.replay((RecorderConfig)((RecorderConfig)Iterables.head((Object[])configs)), (RecorderConfig[])((RecorderConfig[])Iterables.tail((Object[])configs)));
        }
        throw new IllegalArgumentException(String.format("unknown field [%s]", name));
    }

    private Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return this.getField(superclass, name);
            }
            throw e;
        }
    }

    private Resource resourceFrom(BaseResourceSetting resourceSetting) {
        for (String resource : RESOURCES) {
            try {
                Field field = this.getField(resourceSetting.getClass(), resource);
                field.setAccessible(true);
                return this.resourceFrom(resource, (TextContainer)field.get(resourceSetting));
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("resourceSetting is expected");
    }

    private ResponseHandler createCompositeHandler(String name, Map<String, Container> map) {
        List<ResponseHandler> handlers = map.entrySet().stream().map(this.toTargetHandler(name)).collect(Collectors.toList());
        return this.getResponseHandler(handlers);
    }

    private Function<Map.Entry<String, Container>, ResponseHandler> toTargetHandler(String name) {
        return pair -> {
            String result = (String)COMPOSITES.get((Object)name);
            if (result == null) {
                throw new IllegalArgumentException("unknown composite handler name [" + name + "]");
            }
            return this.createResponseHandler((Map.Entry<String, Container>)pair, result);
        };
    }

    private Resource getResource(TextContainer container) {
        if (container.isForTemplate()) {
            return Moco.template((String)container.getText());
        }
        return Moco.text((String)container.getText());
    }

    private Resource getResource(CookieContainer container) {
        if (container.isForTemplate()) {
            return Moco.template((String)container.getTemplate());
        }
        return Moco.text((String)container.getValue());
    }

    private ResponseHandler createResponseHandler(Map.Entry<String, Container> pair, String targetMethodName) {
        Container container = pair.getValue();
        String key = pair.getKey();
        if (container instanceof TextContainer) {
            return this.createResponseHandler(targetMethodName, key, (TextContainer)container);
        }
        if (container instanceof CookieContainer) {
            return this.createCookieResponseHandler(targetMethodName, key, (CookieContainer)container);
        }
        throw new IllegalArgumentException();
    }

    private ResponseHandler createResponseHandler(String target, String key, TextContainer textContainer) {
        try {
            Method method = Moco.class.getMethod(target, String.class, Resource.class);
            return Moco.with((ResponseElement)((ResponseElement)method.invoke(null, key, this.getResource(textContainer))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ResponseHandler createCookieResponseHandler(String target, String key, CookieContainer cookieContainer) {
        try {
            Method method = Moco.class.getMethod(target, String.class, Resource.class, CookieAttribute[].class);
            return (ResponseHandler)method.invoke(null, key, this.getResource(cookieContainer), cookieContainer.getOptions());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Container> castToMap(Object value) {
        return (Map)value;
    }

    private Resource resourceFrom(String name, TextContainer container) {
        if (container.isFileContainer()) {
            return this.fileResource(name, (FileContainer)container);
        }
        return this.textResource(name, container);
    }

    private Resource textResource(String name, TextContainer container) {
        if (container.isRawText()) {
            return DynamicResponseHandlerFactory.invokeTarget(name, container.getText(), Resource.class);
        }
        if (container.isForTemplate()) {
            if ("version".equalsIgnoreCase(name)) {
                return Moco.version((Resource)container.asTemplateResource());
            }
            return container.asTemplateResource(name);
        }
        throw new IllegalArgumentException(String.format("unknown text container:[%s]", container));
    }

    private Resource fileResource(String name, FileContainer fileContainer) {
        if (fileContainer.isForTemplate()) {
            if ("version".equalsIgnoreCase(name)) {
                return Moco.version((Resource)fileContainer.asTemplateResource());
            }
            return fileContainer.asTemplateResource(name);
        }
        TextContainer filename = fileContainer.getName();
        if (filename.isRawText()) {
            return this.asResource(name, fileContainer);
        }
        if (filename.isForTemplate()) {
            Optional<Charset> charset = fileContainer.getCharset();
            ContentResource resource = filename.asTemplateResource();
            return this.asResource(name, (Resource)resource, charset);
        }
        throw new IllegalArgumentException(String.format("unknown file container:[%s]", fileContainer));
    }

    private Resource asResource(String name, Resource resource, Optional<Charset> charset) {
        if (charset.isPresent()) {
            return DynamicResponseHandlerFactory.invokeTarget(name, resource, charset.get(), Resource.class, Resource.class, Charset.class);
        }
        return DynamicResponseHandlerFactory.invokeTarget(name, resource, Resource.class, Resource.class);
    }

    private Resource asResource(String name, FileContainer fileContainer) {
        Optional<Charset> charset = fileContainer.getCharset();
        String text = fileContainer.getName().getText();
        return this.asResource(name, (Resource)Moco.text((String)text), charset);
    }

    public static ImmutableMap<String, RequestExtractor<?>> toVariables(Map<String, TextContainer> props) {
        return ImmutableMap.copyOf(props.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> DynamicResponseHandlerFactory.getRequestExtractor((TextContainer)e.getValue()))));
    }

    private static RequestExtractor<?> getRequestExtractor(TextContainer value) {
        if (value.isRawText()) {
            return Moco.var((Object)value.getText());
        }
        return DynamicResponseHandlerFactory.createRequestExtractor(DynamicResponseHandlerFactory.getExtractorMethod(value.getOperation()), value.getText());
    }
}

