/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.RequestExtractor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.function.Predicate;

public class Dynamics {
    private static final Map<String, String> EXTRACTORS = ImmutableMap.builder().put((Object)"headers", (Object)"header").put((Object)"queries", (Object)"query").put((Object)"xpaths", (Object)"xpath").put((Object)"jsonPaths", (Object)"jsonPath").put((Object)"cookies", (Object)"cookie").put((Object)"forms", (Object)"form").build();

    protected final Predicate<Field> isClassField() {
        return field -> "class".equals(field.getName());
    }

    protected final Predicate<Field> isFinalField() {
        return field -> Modifier.isFinal(field.getModifiers());
    }

    protected final <T> Predicate<Field> fieldExist(T target) {
        return field -> {
            try {
                return field.get(target) != null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected final Iterable<Field> getFields(Class<?> clazz) {
        ImmutableList<Field> fieldsForCurrent = this.getFieldsForCurrent(clazz);
        if (clazz.getSuperclass() == null) {
            return fieldsForCurrent;
        }
        return Iterables.concat(this.getFields(clazz.getSuperclass()), fieldsForCurrent);
    }

    private ImmutableList<Field> getFieldsForCurrent(Class<?> clazz) {
        Object[] fields;
        for (Object field : fields = clazz.getDeclaredFields()) {
            ((Field)field).setAccessible(true);
        }
        return ImmutableList.copyOf((Object[])fields);
    }

    protected final <T> Predicate<Field> isValidField(T target) {
        return this.isClassField().or(this.isFinalField()).negate().and(this.fieldExist(target));
    }

    public static <T> T invokeTarget(String name, Object value, Class<T> clazz) {
        return Dynamics.invokeTarget(name, value, clazz, value.getClass());
    }

    public static <T> T invokeTarget(String name, Object value, Class<T> clazz, Class<?> argClass) {
        try {
            Method method = Moco.class.getMethod(name, argClass);
            Object result = method.invoke(null, value);
            return clazz.cast(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeTarget(String name, Object arg1, Object arg2, Class<T> clazz, Class<?> arg1Class, Class<?> arg2Class) {
        try {
            Method method = Moco.class.getMethod(name, arg1Class, arg2Class);
            Object result = method.invoke(null, arg1, arg2);
            return clazz.cast(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Method getExtractorMethod(String name) {
        try {
            if (EXTRACTORS.containsKey(name)) {
                return Moco.class.getMethod(EXTRACTORS.get(name), String.class);
            }
            throw new RuntimeException("No [" + name + "] extractor found");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected static RequestExtractor createRequestExtractor(Method method, String key) {
        try {
            return (RequestExtractor)RequestExtractor.class.cast(method.invoke(null, key));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

