/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.bootstrap.arg;

import com.github.dreamhead.moco.bootstrap.HttpsArg;
import com.github.dreamhead.moco.bootstrap.ServerType;
import com.github.dreamhead.moco.bootstrap.arg.StartArgs;

public final class HttpsArgs
extends StartArgs {
    private HttpsArgs(Integer port, Integer shutdownPort, String configurationFile, String globalSettings, String env, HttpsArg httpsArg) {
        super(ServerType.HTTPS, port, shutdownPort, configurationFile, globalSettings, env, httpsArg);
    }

    public static Builder httpsArgs() {
        return new Builder();
    }

    public static class Builder {
        private Integer port;
        private Integer shutdownPort;
        private String configurationFile;
        private String settings;
        private String env;
        private HttpsArg httpsArg;

        public final Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public final Builder withShutdownPort(Integer shutdownPort) {
            this.shutdownPort = shutdownPort;
            return this;
        }

        public final Builder withConfigurationFile(String configurationFile) {
            this.configurationFile = configurationFile;
            return this;
        }

        public final Builder withSettings(String settings) {
            this.settings = settings;
            return this;
        }

        public final Builder withEnv(String env) {
            this.env = env;
            return this;
        }

        public final Builder withHttpsArg(HttpsArg httpsArg) {
            this.httpsArg = httpsArg;
            return this;
        }

        public final HttpsArgs build() {
            return new HttpsArgs(this.port, this.shutdownPort, this.configurationFile, this.settings, this.env, this.httpsArg);
        }
    }
}

