/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.parser.deserializer.TextContainerDeserializer;
import com.github.dreamhead.moco.parser.model.Container;
import com.github.dreamhead.moco.parser.model.DynamicResponseHandlerFactory;
import com.github.dreamhead.moco.parser.model.Dynamics;
import com.github.dreamhead.moco.resource.ContentResource;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@JsonDeserialize(using=TextContainerDeserializer.class)
public class TextContainer
implements Container {
    private static final String TEMPLATE_NAME = "template";
    private String text;
    private String operation;
    private Map<String, TextContainer> props = ImmutableMap.of();

    protected TextContainer() {
    }

    public ContentResource asResource() {
        if (this.isRawText()) {
            return Moco.text((String)this.text);
        }
        if (this.isForTemplate()) {
            return this.asTemplateResource();
        }
        return Dynamics.invokeTarget(this.getMethodName(), this.text, ContentResource.class);
    }

    public ContentResource asTemplateResource() {
        return this.asTemplateResource("text");
    }

    private void ensureTemplate() {
        if (!this.isForTemplate()) {
            throw new IllegalArgumentException(this + " is not a template");
        }
    }

    public ContentResource asTemplateResource(String resourceName) {
        this.ensureTemplate();
        if (this.hasProperties()) {
            return Moco.template((ContentResource)Dynamics.invokeTarget(resourceName, this.text, ContentResource.class), DynamicResponseHandlerFactory.toVariables(this.props));
        }
        return Moco.template((ContentResource)Dynamics.invokeTarget(resourceName, this.text, ContentResource.class));
    }

    private String getMethodName() {
        if (this.operation.equalsIgnoreCase("path_resource")) {
            return "pathResource";
        }
        return this.operation;
    }

    public boolean isRawText() {
        return this.operation == null && this.text != null;
    }

    public String getText() {
        return this.text;
    }

    public String getOperation() {
        return this.operation;
    }

    public boolean hasProperties() {
        return !this.props.isEmpty();
    }

    public Map<String, TextContainer> getProps() {
        return this.props;
    }

    public static boolean isForTemplate(String operation) {
        return TEMPLATE_NAME.equalsIgnoreCase(operation);
    }

    public static String getTemplateName() {
        return TEMPLATE_NAME;
    }

    public boolean isForTemplate() {
        return TextContainer.isForTemplate(this.operation);
    }

    public boolean isFileContainer() {
        return false;
    }

    public final String toString() {
        return this.toStringHelper().toString();
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("text", (Object)this.text).add("operation", (Object)this.operation).add("properties", this.props);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String text;
        private String operation;
        private Map<String, TextContainer> props;

        public final Builder withText(String text) {
            this.text = text;
            return this;
        }

        public final Builder withOperation(String operation) {
            this.operation = operation;
            return this;
        }

        public final Builder withProps(Map<String, TextContainer> props) {
            this.props = props;
            return this;
        }

        public final TextContainer build() {
            TextContainer container = new TextContainer();
            container.text = this.text;
            container.operation = this.operation;
            container.props = this.asProps(this.props);
            return container;
        }

        private Map<String, TextContainer> asProps(Map<String, TextContainer> props) {
            if (props != null) {
                return props;
            }
            return ImmutableMap.of();
        }
    }
}

