/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.bootstrap.parser;

import com.github.dreamhead.moco.bootstrap.ParseArgException;
import com.github.dreamhead.moco.bootstrap.ShutdownPortOption;
import com.github.dreamhead.moco.bootstrap.arg.SocketArgs;
import com.github.dreamhead.moco.bootstrap.arg.StartArgs;
import com.github.dreamhead.moco.bootstrap.parser.StartArgsParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public final class SocketArgsParser
extends StartArgsParser {
    @Override
    protected StartArgs parseArgs(CommandLine cmd) {
        String port = cmd.getOptionValue("p");
        String config = cmd.getOptionValue("c");
        String shutdownPort = cmd.getOptionValue("s");
        boolean quiet = cmd.hasOption("q");
        if (config == null) {
            throw new ParseArgException("config is required");
        }
        if (cmd.getArgs().length != 1) {
            throw new ParseArgException("only one arg not allowed");
        }
        return SocketArgs.socketArgs().withPort(SocketArgsParser.getPort(port)).withShutdownPort(SocketArgsParser.getPort(shutdownPort)).withConfigurationFile(config).withQuiet(quiet).build();
    }

    @Override
    protected Options options() {
        Options options = new Options();
        options.addOption(this.configOption());
        options.addOption(this.portOption());
        options.addOption(ShutdownPortOption.shutdownPortOption());
        return options;
    }
}

