/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.deserializer;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.github.dreamhead.moco.parser.model.CookieContainer;
import com.github.dreamhead.moco.parser.model.LatencyContainer;
import com.github.dreamhead.moco.util.Strings;
import java.io.IOException;

public final class CookieContainerDeserializer
extends JsonDeserializer<CookieContainer> {
    public CookieContainer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jp.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            return CookieContainer.newContainer(Strings.strip((String)jp.getText()));
        }
        if (currentToken == JsonToken.START_OBJECT) {
            jp.nextToken();
            InternalCookieContainer container = (InternalCookieContainer)jp.readValueAs(InternalCookieContainer.class);
            return container.toContainer();
        }
        return (CookieContainer)ctxt.handleUnexpectedToken(CookieContainer.class, jp);
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static final class InternalCookieContainer {
        private String value;
        private String path;
        private String domain;
        private LatencyContainer maxAge;
        private boolean secure;
        private boolean httpOnly;
        private String template;

        public CookieContainer toContainer() {
            return CookieContainer.newContainer(this.value, this.path, this.domain, this.maxAge, this.secure, this.httpOnly, this.template);
        }
    }
}

