/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.bootstrap.arg.StartArgs;
import com.github.dreamhead.moco.runner.JsonRunner;
import com.github.dreamhead.moco.runner.Runner;
import com.github.dreamhead.moco.runner.SettingRunner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileRunner
implements Runner {
    private Logger logger = LoggerFactory.getLogger(FileRunner.class);
    private Runner runner = this.newRunner();

    protected abstract Runner newRunner();

    private FileRunner() {
    }

    public synchronized void restart() {
        this.runner.stop();
        this.runner = this.refreshRunner(this.runner);
        this.runner.run();
    }

    private Runner refreshRunner(Runner current) {
        try {
            return this.newRunner();
        }
        catch (Exception e) {
            this.logger.warn("Fail to load new runner: " + e.getMessage());
            return current;
        }
    }

    public Runner getRunner() {
        return this.runner;
    }

    @Override
    public void run() {
        this.runner.run();
    }

    @Override
    public void stop() {
        this.runner.stop();
    }

    public static FileRunner createConfigurationFileRunner(final Iterable<File> files, final StartArgs startArgs) {
        return new FileRunner(){

            @Override
            protected Runner newRunner() {
                return JsonRunner.newJsonRunnerWithStreams(FileRunner.toInputStreams(files), startArgs);
            }
        };
    }

    public static FileRunner createSettingFileRunner(final File settingsFile, final StartArgs startArgs) {
        return new FileRunner(){

            @Override
            protected Runner newRunner() {
                return new SettingRunner(FileRunner.toInputStream(settingsFile), startArgs);
            }
        };
    }

    private static FileInputStream toInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new MocoException((Throwable)e);
        }
    }

    private static Iterable<InputStream> toInputStreams(Iterable<File> files) {
        return StreamSupport.stream(files.spliterator(), false).map(FileRunner::toInputStream).collect(Collectors.toList());
    }
}

