/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner;

import com.github.dreamhead.moco.HttpResponseSetting;
import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.HttpsCertificate;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseElement;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.Server;
import com.github.dreamhead.moco.SocketServer;
import com.github.dreamhead.moco.bootstrap.arg.StartArgs;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.ActualSocketServer;
import com.github.dreamhead.moco.internal.BaseActualServer;
import com.github.dreamhead.moco.parser.HttpServerParser;
import com.github.dreamhead.moco.parser.SocketServerParser;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.runner.Runner;
import com.github.dreamhead.moco.runner.RunnerSetting;
import com.github.dreamhead.moco.runner.StandaloneRunner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import java.io.InputStream;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class JsonRunner
implements Runner {
    private final HttpServerParser httpParser = new HttpServerParser();
    private final SocketServerParser socketParser = new SocketServerParser();
    private final StandaloneRunner runner = new StandaloneRunner();
    private final Server server;

    private JsonRunner(Iterable<? extends RunnerSetting> settings, StartArgs startArgs) {
        this.server = this.newServer(settings, startArgs);
    }

    private Server newServer(Iterable<? extends RunnerSetting> settings, StartArgs startArgs) {
        if (startArgs.isSocket()) {
            return this.createSocketServer(settings, startArgs);
        }
        return this.createHttpServer(settings, startArgs);
    }

    @Override
    public void run() {
        this.runner.run(this.server);
    }

    @Override
    public void stop() {
        this.runner.stop();
    }

    private SocketServer createSocketServer(Iterable<? extends RunnerSetting> settings, StartArgs startArgs) {
        int port = startArgs.getPort().orElse(0);
        ActualSocketServer socketServer = ActualSocketServer.createSocketServer((int)port, (boolean)startArgs.isQuiet());
        for (RunnerSetting runnerSetting : settings) {
            SocketServer parsedServer = (SocketServer)this.socketParser.parseServer(runnerSetting.getStreams(), port, startArgs.isQuiet(), this.toConfigs(runnerSetting));
            socketServer = this.mergeServer((SocketServer)socketServer, parsedServer);
        }
        return socketServer;
    }

    private SocketServer mergeServer(SocketServer socketServer, SocketServer parsedServer) {
        ActualSocketServer thisServer = (ActualSocketServer)socketServer;
        return (SocketServer)thisServer.mergeServer((BaseActualServer)((ActualSocketServer)parsedServer));
    }

    private HttpServer createHttpServer(Iterable<? extends RunnerSetting> settings, StartArgs startArgs) {
        HttpServer targetServer = this.createBaseHttpServer(settings, startArgs);
        ((HttpResponseSetting)targetServer.request(Moco.by((Resource)Moco.uri((String)"/favicon.ico")))).response(Moco.with((ResponseElement)Moco.pathResource((String)"favicon.png")), new ResponseHandler[]{Moco.with((ResponseElement)Moco.header((String)"Content-Type", (String)MediaType.PNG.toString()))});
        return targetServer;
    }

    private HttpServer createBaseHttpServer(Iterable<? extends RunnerSetting> settings, StartArgs startArgs) {
        HttpServer targetServer = this.createHttpServer(startArgs);
        for (RunnerSetting runnerSetting : settings) {
            HttpServer parsedServer = (HttpServer)this.httpParser.parseServer(runnerSetting.getStreams(), startArgs.getPort().orElse(0), startArgs.isQuiet(), this.toConfigs(runnerSetting));
            targetServer = this.mergeServer(targetServer, parsedServer);
        }
        return targetServer;
    }

    private HttpServer createHttpServer(StartArgs startArgs) {
        int port = startArgs.getPort().orElse(0);
        if (startArgs.isHttps()) {
            return ActualHttpServer.createHttpsServer((int)port, (boolean)startArgs.isQuiet(), (HttpsCertificate)startArgs.getHttpsCertificate().get());
        }
        return ActualHttpServer.createHttpServer((int)port, (boolean)startArgs.isQuiet());
    }

    private MocoConfig[] toConfigs(RunnerSetting setting) {
        ImmutableList.Builder builder = ImmutableList.builder();
        setting.context().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        setting.fileRoot().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        setting.request().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        setting.response().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return (MocoConfig[])Iterables.toArray((Iterable)builder.build(), MocoConfig.class);
    }

    private HttpServer mergeServer(HttpServer server, HttpServer parsedServer) {
        ActualHttpServer thisServer = (ActualHttpServer)server;
        return (HttpServer)thisServer.mergeServer((BaseActualServer)((ActualHttpServer)parsedServer));
    }

    public static JsonRunner newJsonRunnerWithStreams(Iterable<? extends InputStream> streams, StartArgs startArgs) {
        return JsonRunner.newJsonRunnerWithSetting(StreamSupport.stream(streams.spliterator(), false).map(input -> RunnerSetting.aRunnerSetting().addStream((InputStream)input).build()).collect(Collectors.toList()), startArgs);
    }

    public static JsonRunner newJsonRunnerWithSetting(Iterable<? extends RunnerSetting> settings, StartArgs startArgs) {
        return new JsonRunner(settings, startArgs);
    }
}

