/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner.watcher;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.runner.watcher.ShutdownListener;
import com.github.dreamhead.moco.runner.watcher.Watcher;
import com.github.dreamhead.moco.server.MocoServer;
import com.google.common.io.CharSource;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.string.StringDecoder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShutdownMocoRunnerWatcher
implements Watcher {
    private static Logger logger = LoggerFactory.getLogger(ShutdownMocoRunnerWatcher.class);
    private final MocoServer server = new MocoServer();
    private final int shutdownPort;
    private final String shutdownKey;
    private final ShutdownListener shutdownListener;
    private int port;

    public ShutdownMocoRunnerWatcher(int shutdownPort, String shutdownKey, ShutdownListener shutdownListener) {
        this.shutdownPort = shutdownPort;
        this.shutdownKey = shutdownKey;
        this.shutdownListener = shutdownListener;
    }

    @Override
    public void start() {
        int actualPort;
        this.port = actualPort = this.server.start(this.shutdownPort, (ChannelInitializer)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new StringDecoder());
                pipeline.addLast("handler", (ChannelHandler)new ShutdownHandler());
            }
        });
        logger.info("Shutdown port is {}", (Object)actualPort);
    }

    @Override
    public void stop() {
        this.server.stop();
    }

    public int port() {
        return this.port;
    }

    @ChannelHandler.Sharable
    private class ShutdownHandler
    extends SimpleChannelInboundHandler<String> {
        private final ExecutorService service = Executors.newCachedThreadPool();

        private ShutdownHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, String msg) {
            if (this.shouldShutdown(msg)) {
                ShutdownMocoRunnerWatcher.this.shutdownListener.onShutdown();
                this.shutdownMonitorSelf();
            }
        }

        private void shutdownMonitorSelf() {
            this.service.execute(ShutdownMocoRunnerWatcher.this::stop);
        }

        private boolean shouldShutdown(String message) {
            try {
                return ShutdownMocoRunnerWatcher.this.shutdownKey.equals(CharSource.wrap((CharSequence)message).readFirstLine());
            }
            catch (IOException e) {
                throw new MocoException((Throwable)e);
            }
        }
    }
}

