/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.runner.watcher;

import com.github.dreamhead.moco.runner.FileRunner;
import com.github.dreamhead.moco.runner.Runner;
import com.github.dreamhead.moco.runner.watcher.DefaultWatcherFactory;
import com.github.dreamhead.moco.runner.watcher.FileWatcherFactory;
import com.github.dreamhead.moco.runner.watcher.ShutdownMocoRunnerWatcher;
import com.github.dreamhead.moco.runner.watcher.Watcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.File;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WatcherFactory {
    private static Logger logger = LoggerFactory.getLogger(WatcherFactory.class);
    private final FileWatcherFactory factory = new DefaultWatcherFactory();

    public ShutdownMocoRunnerWatcher createShutdownWatcher(Runner runner, Integer shutdownPort, String shutdownKey) {
        return new ShutdownMocoRunnerWatcher(shutdownPort, shutdownKey, runner::stop);
    }

    public Watcher createConfigurationWatcher(Iterable<File> files, FileRunner fileRunner) {
        return this.factory.createWatcher(this.listener(fileRunner), (File[])Iterators.toArray(files.iterator(), File.class));
    }

    public Watcher createSettingWatcher(File settingsFile, Iterable<File> configurationFiles, FileRunner fileRunner) {
        ImmutableList files = ImmutableList.builder().add((Object)settingsFile).addAll(configurationFiles).build();
        return this.factory.createWatcher(this.listener(fileRunner), (File[])files.toArray((Object[])new File[0]));
    }

    private Function<File, Void> listener(FileRunner fileRunner) {
        return file -> {
            logger.info("{} change detected.", (Object)file.getName());
            fileRunner.restart();
            return null;
        };
    }
}

