/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.mybatis.pro.base.codec.enums;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.github.dreamroute.mybatis.pro.base.codec.enums.EnumMarker;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class EnumMarkerDeserializerForCollection
extends JsonDeserializer<Collection<Enum<? extends EnumMarker>>> {
    public Collection<Enum<? extends EnumMarker>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Field field;
        ArrayNode treeNode = (ArrayNode)p.readValueAsTree();
        try {
            field = p.getCurrentValue().getClass().getDeclaredField(p.currentName());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        field.setAccessible(true);
        if (!field.getType().equals(Collection.class)) {
            return null;
        }
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Class actualTypeArgument = (Class)genericType.getActualTypeArguments()[0];
        ArrayList<Enum<? extends EnumMarker>> result = new ArrayList<Enum<? extends EnumMarker>>();
        Iterator elements = treeNode.elements();
        while (elements.hasNext()) {
            String v = ((JsonNode)elements.next()).asText();
            if (EnumMarker.class.isAssignableFrom(actualTypeArgument)) {
                Object enumMarker = EnumMarker.valueOf(actualTypeArgument, Integer.parseInt(v));
                result.add((Enum<? extends EnumMarker>)enumMarker);
                continue;
            }
            result.add((Enum<? extends EnumMarker>)((Object)v));
        }
        return result;
    }
}

