/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.mybatis.pro.base.codec.enums;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.dreamroute.mybatis.pro.base.codec.date.DateDeserializer;
import com.github.dreamroute.mybatis.pro.base.codec.date.DateSerializer;
import com.github.dreamroute.mybatis.pro.base.codec.enums.EnumMarkerDeserializer;
import com.github.dreamroute.mybatis.pro.base.codec.enums.EnumMarkerSerializer;
import com.github.dreamroute.mybatis.pro.base.codec.enums.EnumMarkerSerializerForWeb;
import java.util.Date;
import java.util.List;

public class JsonUtil {
    private static final ObjectMapper MAPPER = new JsonMapper();
    private static final ObjectMapper MAPPER_FOR_WEB = new JsonMapper();

    private JsonUtil() {
    }

    public static String toJsonStr(Object target) {
        try {
            return MAPPER.writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u5e8f\u5217\u5316\u5931\u8d25: ", e);
        }
    }

    public static String toJsonStrForWeb(Object target) {
        try {
            return MAPPER_FOR_WEB.writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u5e8f\u5217\u5316\u5931\u8d25: ", e);
        }
    }

    public static <T> T parseObj(String inputJson, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(inputJson, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u9700\u8981\u88ab\u53cd\u5e8f\u5217\u5316\u7684\u5b57\u7b26\u4e32: " + inputJson, e);
        }
    }

    public static <T> List<T> parseArr(String inputJson, Class<T> clazz) {
        try {
            CollectionType javaType = MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)MAPPER.readValue(inputJson, (JavaType)javaType);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("\u53cd\u5e8f\u5217\u5316\u5931\u8d25, \u9700\u8981\u88ab\u53cd\u5e8f\u5217\u5316\u7684\u5b57\u7b26\u4e32: " + inputJson, e);
        }
    }

    static {
        EnumMarkerDeserializer emd = new EnumMarkerDeserializer();
        DateSerializer ds = new DateSerializer();
        DateDeserializer dd = new DateDeserializer();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Enum.class, (JsonSerializer)new EnumMarkerSerializer());
        module.addDeserializer(Enum.class, (JsonDeserializer)emd);
        module.addSerializer(Date.class, (JsonSerializer)ds);
        module.addDeserializer(Date.class, (JsonDeserializer)dd);
        MAPPER.registerModule((Module)module);
        SimpleModule moduleForWeb = new SimpleModule();
        moduleForWeb.addSerializer(Enum.class, (JsonSerializer)new EnumMarkerSerializerForWeb());
        moduleForWeb.addDeserializer(Enum.class, (JsonDeserializer)emd);
        moduleForWeb.addSerializer(Date.class, (JsonSerializer)ds);
        moduleForWeb.addDeserializer(Date.class, (JsonDeserializer)dd);
        MAPPER_FOR_WEB.registerModule((Module)moduleForWeb);
    }
}

