/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.mybatis.pro.base.typehandler;

import com.github.dreamroute.mybatis.pro.base.codec.enums.EnumMarker;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class EnumTypeHandler<E extends EnumMarker>
extends BaseTypeHandler<EnumMarker> {
    private Class<E> type;

    public EnumTypeHandler() {
    }

    public EnumTypeHandler(Class<E> type) {
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, EnumMarker parameter, JdbcType jdbcType) throws SQLException {
        ps.setObject(i, parameter.getValue());
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int value = rs.getInt(columnName);
        if (rs.wasNull()) {
            return null;
        }
        try {
            return EnumMarker.valueOf(this.type, value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert " + value + " to " + this.type.getSimpleName() + " by ordinal value.", ex);
        }
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int value = rs.getInt(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        try {
            return EnumMarker.valueOf(this.type, value);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot convert " + value + " to " + this.type.getSimpleName() + " by ordinal value.", ex);
        }
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        throw new IllegalArgumentException("MyBatisPro enum typehandler not support CallableStatement.");
    }
}

