/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamroute.mybatis.pro.base.util;

import java.io.IOException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class ClassPathUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassPathUtil.class);
    public static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";

    public static String[] resolvePackage(String packagePath) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        packagePath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packagePath) + "/" + DEFAULT_RESOURCE_PATTERN;
        HashSet<String> result = new HashSet<String>();
        try {
            Resource[] resources = resolver.getResources(packagePath);
            if (resources != null && resources.length > 0) {
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    try {
                        result.add(Class.forName(metadataReader.getClassMetadata().getClassName()).getPackage().getName());
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toArray(new String[0]);
    }
}

